/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class BacktankUtil {
    private static final List<Function<LivingEntity, List<ItemStack>>> BACKTANK_SUPPLIERS = new ArrayList<Function<LivingEntity, List<ItemStack>>>();

    public static List<ItemStack> getAllWithAir(LivingEntity entity) {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>();
        for (Function<LivingEntity, List<ItemStack>> supplier : BACKTANK_SUPPLIERS) {
            List<ItemStack> result = supplier.apply(entity);
            for (ItemStack stack : result) {
                if (!BacktankUtil.hasAirRemaining(stack)) continue;
                all.add(stack);
            }
        }
        all.sort((a, b) -> Float.compare(BacktankUtil.getAir(a), BacktankUtil.getAir(b)));
        return all;
    }

    public static boolean hasAirRemaining(ItemStack backtank) {
        return BacktankUtil.getAir(backtank) > 0.0f;
    }

    public static float getAir(ItemStack backtank) {
        CompoundTag tag = backtank.m_41784_();
        return Math.min(tag.m_128457_("Air"), (float)BacktankUtil.maxAir(backtank));
    }

    public static void consumeAir(LivingEntity entity, ItemStack backtank, float i) {
        CompoundTag tag = backtank.m_41784_();
        int maxAir = BacktankUtil.maxAir(backtank);
        float air = BacktankUtil.getAir(backtank);
        float newAir = Math.max(air - i, 0.0f);
        tag.m_128350_("Air", Math.min(newAir, (float)maxAir));
        backtank.m_41751_(tag);
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BacktankUtil.sendWarning(player, air, newAir, (float)maxAir / 10.0f);
        BacktankUtil.sendWarning(player, air, newAir, 1.0f);
    }

    private static void sendWarning(ServerPlayer player, float air, float newAir, float threshold) {
        if (newAir > threshold) {
            return;
        }
        if (air <= threshold) {
            return;
        }
        boolean depleted = threshold == 1.0f;
        MutableComponent component = Lang.translateDirect(depleted ? "backtank.depleted" : "backtank.low", new Object[0]);
        AllSoundEvents.DENY.play(player.f_19853_, null, (Vec3i)player.m_142538_(), 1.0f, 1.25f);
        AllSoundEvents.STEAM.play(player.f_19853_, null, (Vec3i)player.m_142538_(), 0.5f, 0.5f);
        player.f_8906_.m_141995_((Packet)new ClientboundSetTitlesAnimationPacket(10, 40, 10));
        player.f_8906_.m_141995_((Packet)new ClientboundSetSubtitleTextPacket((Component)Components.literal("\u26a0 ").m_130940_(depleted ? ChatFormatting.RED : ChatFormatting.GOLD).m_7220_((Component)component.m_130940_(ChatFormatting.GRAY))));
        player.f_8906_.m_141995_((Packet)new ClientboundSetTitleTextPacket(Components.immutableEmpty()));
    }

    public static int maxAir(ItemStack backtank) {
        return BacktankUtil.maxAir(EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AllEnchantments.CAPACITY.get()), (ItemStack)backtank));
    }

    public static int maxAir(int enchantLevel) {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get() + (Integer)AllConfigs.server().equipment.enchantedBacktankCapacity.get() * enchantLevel;
    }

    public static int maxAirWithoutEnchants() {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get();
    }

    public static boolean canAbsorbDamage(LivingEntity entity, int usesPerTank) {
        if (usesPerTank == 0) {
            return true;
        }
        if (entity instanceof Player && ((Player)entity).m_7500_()) {
            return true;
        }
        List<ItemStack> backtanks = BacktankUtil.getAllWithAir(entity);
        if (backtanks.isEmpty()) {
            return false;
        }
        float cost = (float)BacktankUtil.maxAirWithoutEnchants() / (float)usesPerTank;
        BacktankUtil.consumeAir(entity, backtanks.get(0), cost);
        return true;
    }

    public static boolean isBarVisible(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return false;
        }
        Player player = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
        if (player == null) {
            return false;
        }
        List<ItemStack> backtanks = BacktankUtil.getAllWithAir((LivingEntity)player);
        if (backtanks.isEmpty()) {
            return stack.m_41768_();
        }
        return true;
    }

    public static int getBarWidth(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 13;
        }
        Player player = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
        if (player == null) {
            return 13;
        }
        List<ItemStack> backtanks = BacktankUtil.getAllWithAir((LivingEntity)player);
        if (backtanks.isEmpty()) {
            return Math.round(13.0f - (float)stack.m_41773_() / (float)stack.m_41776_() * 13.0f);
        }
        if (backtanks.size() == 1) {
            return backtanks.get(0).m_41720_().m_142158_(backtanks.get(0));
        }
        int sumBarWidth = backtanks.stream().map(backtank -> backtank.m_41720_().m_142158_(backtank)).reduce(0, Integer::sum);
        return Math.round((float)sumBarWidth / (float)backtanks.size());
    }

    public static int getBarColor(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 0;
        }
        Player player = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
        if (player == null) {
            return 0;
        }
        List<ItemStack> backtanks = BacktankUtil.getAllWithAir((LivingEntity)player);
        if (backtanks.isEmpty()) {
            return Mth.m_14169_((float)(Math.max(0.0f, 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_()) / 3.0f), (float)1.0f, (float)1.0f);
        }
        return backtanks.get(0).m_41720_().m_142159_(backtanks.get(0));
    }

    public static void addBacktankSupplier(Function<LivingEntity, List<ItemStack>> supplier) {
        BACKTANK_SUPPLIERS.add(supplier);
    }

    static {
        BacktankUtil.addBacktankSupplier(entity -> {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : entity.m_6168_()) {
                if (!AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.matches(itemStack)) continue;
                stacks.add(itemStack);
            }
            return stacks;
        });
    }
}

