/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreVeinGenerator;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    public static int generationChance;
    public static int finiteAmountBase;
    public static int maxExtractorsPerVein;
    public static boolean defaultInfinite;

    private static void load(ModConfig modConfig) {
        if (modConfig.getType() == ModConfig.Type.SERVER) {
            generationChance = (Integer)Config.SERVER.generationChance.get();
            finiteAmountBase = (Integer)Config.SERVER.finiteAmountBase.get();
            defaultInfinite = (Boolean)Config.SERVER.defaultInfinite.get();
            maxExtractorsPerVein = (Integer)Config.SERVER.maxExtractorsPerVein.get();
            OreVeinGenerator.invalidate();
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        CreateOreExcavation.LOGGER.info("Loaded Create Ore Excavation config file {}", (Object)configEvent.getConfig().getFileName());
        Config.load(configEvent.getConfig());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        CreateOreExcavation.LOGGER.info("Create Ore Excavation config just got changed on the file system!");
        Config.load(configEvent.getConfig());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public ForgeConfigSpec.IntValue generationChance;
        public ForgeConfigSpec.IntValue finiteAmountBase;
        public ForgeConfigSpec.BooleanValue defaultInfinite;
        public ForgeConfigSpec.IntValue maxExtractorsPerVein;

        private Server(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"IMPORTANT NOTICE:", "You can add more entries using KubeJS", "https://github.com/tom5454/Create-Ore-Excavation#kubejs"}).define("importantInfo", true);
            this.generationChance = builder.comment("Weight value for empty chunk").translation("config.coe.generationChance").defineInRange("generationChance", 5000, 1, Integer.MAX_VALUE);
            this.finiteAmountBase = builder.comment("Finite vein base amount").translation("config.coe.finiteAmountBase").defineInRange("finiteAmountBase", 1000, 1, Integer.MAX_VALUE);
            this.defaultInfinite = builder.comment("Veins infinite by default").translation("config.coe.defaultInfinite").define("defaultInfinite", true);
            this.maxExtractorsPerVein = builder.comment("Max number of extractor per ore vein, Set to 0 for infinite").translation("config.coe.maxExtractorsPerVein").defineInRange("maxExtractorsPerVein", 0, 0, 64);
        }
    }

    public static class Common {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> multiblockInvs;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"IMPORTANT NOTICE:", "THIS IS ONLY THE COMMON CONFIG. It does not contain all the values adjustable for Create Ore Excavation", "The settings have been moved to createoreexcavation-server.toml", "That file is PER WORLD, meaning you have to go into 'saves/<world name>/serverconfig' to adjust it. Those changes will then only apply for THAT WORLD.", "You can then take that config file and put it in the 'defaultconfigs' folder to make it apply automatically to all NEW worlds you generate FROM THERE ON.", "This may appear confusing to many of you, but it is a new sensible way to handle configuration, because the server configuration is synced when playing multiplayer."}).define("importantInfo", true);
        }
    }
}

