/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.Registration;
import com.tom.createores.jei.AnimatedBlock;
import com.tom.createores.jei.ExcavatingCategory;
import com.tom.createores.jei.JEIHandler;
import com.tom.createores.recipe.DrillingRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DrillingCategory
extends ExcavatingCategory<DrillingRecipe> {
    public DrillingCategory() {
        this.block = new AnimatedBlock(Registration.DRILL_BLOCK.getDefaultState(), 11.0f);
        this.icon = new DoubleItemIcon(() -> Registration.DRILL_BLOCK.asStack(), () -> new ItemStack((ItemLike)CreateOreExcavation.NORMAL_DRILL_ITEM.get()));
    }

    public Component getTitle() {
        return new TranslatableComponent("jei.coe.recipe.drilling");
    }

    @Override
    public RecipeType<DrillingRecipe> getRecipeType() {
        return JEIHandler.DRILLING;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, DrillingRecipe recipe, IFocusGroup focuses) {
        super.setRecipe(builder, recipe, focuses);
        if (recipe.getDrillingFluid() != FluidIngredient.EMPTY) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 69, 3).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, CreateRecipeCategory.withImprovedVisibility((List)recipe.getDrillingFluid().getMatchingFluidStacks()))).addTooltipCallback(CreateRecipeCategory.addFluidTooltip((int)recipe.getDrillingFluid().getRequiredAmount()));
        }
        int xOffset = this.getBackground().getWidth() / 2;
        int yOffset = 86;
        this.layoutOutput(recipe).forEach(layoutEntry -> ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xOffset + layoutEntry.posX() + 1, yOffset + layoutEntry.posY() + 1).setBackground(CreateRecipeCategory.getRenderedSlot((ProcessingOutput)layoutEntry.output()), -1, -1).addItemStack(layoutEntry.output().getStack())).addTooltipCallback(CreateRecipeCategory.addStochasticTooltip((ProcessingOutput)layoutEntry.output())));
    }

    private List<LayoutEntry> layoutOutput(DrillingRecipe recipe) {
        int size = recipe.getOutput().size();
        ArrayList<LayoutEntry> positions = new ArrayList<LayoutEntry>(size);
        LayoutHelper layout = LayoutHelper.centeredHorizontal((int)size, (int)1, (int)18, (int)18, (int)1);
        for (ProcessingOutput result : recipe.getOutput()) {
            positions.add(new LayoutEntry(result, layout.getX(), layout.getY()));
            layout.next();
        }
        return positions;
    }

    private record LayoutEntry(ProcessingOutput output, int posX, int posY) {
    }
}

