/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.kubejs.ExcavatingRecipeJS;
import com.tom.createores.kubejs.KubeJSExcavation;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.util.ListJS;
import net.minecraft.network.chat.Component;

public class DrillingRecipeJS
extends ExcavatingRecipeJS<DrillingRecipeJS> {
    @Override
    public void create(ListJS args) {
        super.create(args);
        this.inputItems.add(IngredientJS.of((Object)("#" + CreateOreExcavation.DRILL_TAG.f_203868_())));
        this.outputItems.addAll(this.parseResultItemList(args.get(0)));
        Component name = KubeJSExcavation.parseComponent(args.get(1));
        int weight = ((Number)args.get(2)).intValue();
        int ticks = ((Number)args.get(3)).intValue();
        if (weight < 1) {
            throw new RecipeExceptionJS("Weight must be higher than 0");
        }
        if (ticks < 1) {
            throw new RecipeExceptionJS("Ticks must be higher than 0");
        }
        this.json.addProperty("weight", (Number)weight);
        this.json.addProperty("ticks", (Number)ticks);
        this.json.addProperty("name", Component.Serializer.m_130703_((Component)name));
    }

    public void deserialize() {
        this.inputItems.add(IngredientJS.ingredientFromRecipeJson((JsonElement)this.json.get("drill")));
        this.outputItems.addAll(this.parseResultItemList(this.json.get("output")));
    }

    public void serialize() {
        if (this.serializeInputs) {
            this.json.add("drill", ((IngredientJS)this.inputItems.get(0)).toJson());
        }
        if (this.serializeOutputs) {
            JsonArray results = new JsonArray();
            for (ItemStackJS out : this.outputItems) {
                results.add(out.toResultJson());
            }
            this.json.add("output", (JsonElement)results);
        }
    }

    public DrillingRecipeJS fluid(FluidStackJS fluid) {
        this.json.add("fluid", (JsonElement)fluid.toJson());
        this.save();
        return this;
    }
}

