/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.base;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.noeppi_noeppi.libx.base.tile.BlockEntityBase;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import io.github.noeppi_noeppi.libx.capability.ItemCapabilities;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.item.ISparkEntity;
import vazkii.botania.api.mana.IKeyLocked;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.tile.mana.IThrottledPacket;

@OnlyIn(value=Dist.CLIENT, _interface=IWandHUD.class)
public abstract class BotanicalTile
extends BlockEntityBase
implements IManaPool,
IKeyLocked,
ISparkAttachable,
IThrottledPacket,
IWandHUD,
TickableBlock {
    private int mana;
    private final int manaCap;
    private String inputKey = "";
    private String outputKey = "";
    private final LazyOptional<IAdvancedItemHandlerModifiable> capability = this.createCap(this::getInventory);

    public BotanicalTile(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state, int manaCap) {
        super(blockEntityTypeIn, pos, state);
        this.manaCap = manaCap;
    }

    protected LazyOptional<IAdvancedItemHandlerModifiable> createCap(Supplier<IItemHandlerModifiable> inventory) {
        return ItemCapabilities.create(inventory, this.getExtracts(inventory), this.getInserts(inventory));
    }

    protected abstract Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> var1);

    protected BiPredicate<Integer, ItemStack> getInserts(Supplier<IItemHandlerModifiable> inventory) {
        return null;
    }

    @Nonnull
    public abstract BaseItemStackHandler getInventory();

    public abstract int getComparatorOutput();

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    @Nonnull
    public <X> LazyOptional<X> getCapability(@Nonnull Capability<X> cap, Direction direction) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.capability.cast();
        }
        if (!this.f_58859_ && this.actAsMana() && (cap == BotaniaForgeCapabilities.MANA_RECEIVER || cap == BotaniaForgeCapabilities.SPARK_ATTACHABLE)) {
            return LazyOptional.of(() -> this).cast();
        }
        return (LazyOptional)DistExecutor.unsafeRunForDist(() -> () -> {
            if (!this.f_58859_ && this.actAsMana() && cap == BotaniaForgeClientCapabilities.WAND_HUD) {
                return LazyOptional.of(() -> this).cast();
            }
            return super.getCapability(cap, direction);
        }, () -> () -> super.getCapability(cap, direction));
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.getInventory().deserializeNBT(tag.m_128469_("inv"));
        this.mana = tag.m_128451_("mana");
        if (tag.m_128441_("inputKey")) {
            this.inputKey = tag.m_128461_("inputKey");
        }
        if (tag.m_128441_("outputKey")) {
            this.outputKey = tag.m_128461_("outputKey");
        }
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inv", (Tag)this.getInventory().serializeNBT());
        nbt.m_128405_("mana", this.getCurrentMana());
        nbt.m_128359_("inputKey", this.inputKey);
        nbt.m_128359_("outputKey", this.outputKey);
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return;
        }
        this.getInventory().deserializeNBT(tag.m_128469_("inv"));
        this.mana = tag.m_128451_("mana");
        if (tag.m_128441_("inputKey")) {
            this.inputKey = tag.m_128461_("inputKey");
        }
        if (tag.m_128441_("outputKey")) {
            this.outputKey = tag.m_128461_("outputKey");
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("inv", (Tag)this.getInventory().serializeNBT());
        nbt.m_128405_("mana", this.getCurrentMana());
        nbt.m_128359_("inputKey", this.inputKey);
        nbt.m_128359_("outputKey", this.outputKey);
        return nbt;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(PoseStack poseStack, Minecraft minecraft) {
        ItemStack block = new ItemStack((ItemLike)this.m_58900_().m_60734_());
        String name = block.m_41786_().getString();
        int color = 0x4444FF;
        HUDHandler.drawSimpleManaHUD((PoseStack)poseStack, (int)color, (int)this.getCurrentMana(), (int)this.getManaCap(), (String)name);
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUDHandler.manaBar);
        RenderSystem.m_69461_();
    }

    public String getInputKey() {
        return this.inputKey;
    }

    public String getOutputKey() {
        return this.outputKey;
    }

    public boolean canAttachSpark(ItemStack itemStack) {
        return this.actAsMana();
    }

    public void attachSpark(IManaSpark entity) {
    }

    public int getAvailableSpaceForMana() {
        if (!this.actAsMana()) {
            return 0;
        }
        return Math.max(Math.max(0, this.getManaCap() - this.getCurrentMana()), 0);
    }

    public IManaSpark getAttachedSpark() {
        if (!this.actAsMana()) {
            return null;
        }
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_142082_(1, 1, 1)), (Predicate)Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity entity = (Entity)sparks.get(0);
            return (IManaSpark)entity;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return !this.actAsMana();
    }

    public boolean isFull() {
        return this.getCurrentMana() >= this.getManaCap();
    }

    public void receiveMana(int i) {
        int old = this.getCurrentMana();
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + i, this.getManaCap()));
        if (old != this.getCurrentMana()) {
            this.m_6596_();
            this.setDispatchable();
        }
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public int getManaCap() {
        return this.manaCap;
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public DyeColor getColor() {
        return null;
    }

    public void setColor(DyeColor dyeColor) {
    }

    public void markDispatchable() {
        this.setDispatchable();
    }

    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    public boolean actAsMana() {
        return true;
    }
}

