/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import de.melanx.botanicalmachinery.blocks.tiles.BlockEntityIndustrialAgglomerationFactory;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import io.github.noeppi_noeppi.libx.render.block.RotatedBlockRenderer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;

public class IndustrialAgglomerationFactoryRenderer
extends RotatedBlockRenderer<BlockEntityIndustrialAgglomerationFactory> {
    protected void doRender(@Nonnull BlockEntityIndustrialAgglomerationFactory tile, float partialTick, @Nonnull PoseStack ms, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.industrialAgglomerationFactory) {
            return;
        }
        double progressLeft = 1.0 - (double)tile.getProgress() / (double)tile.getMaxProgress();
        this.renderStack(tile.getInventory().getStackInSlot(0), ms, buffer, partialTick, progressLeft, 0.0f, light);
        this.renderStack(tile.getInventory().getStackInSlot(1), ms, buffer, partialTick, progressLeft, 120.0f, light);
        this.renderStack(tile.getInventory().getStackInSlot(2), ms, buffer, partialTick, progressLeft, 240.0f, light);
        if (!tile.getInventory().getStackInSlot(3).m_41619_()) {
            float time = (float)ClientTickHandler.ticksInGame + partialTick;
            ms.m_85836_();
            ms.m_85837_(0.5, 0.7, 0.5);
            ms.m_85841_(0.3f, 0.3f, 0.3f);
            ms.m_85845_(Vector3f.f_122225_.m_122240_(-time));
            ms.m_85837_(0.0, 0.075 * Math.sin((double)time / 5.0), 0.0);
            Minecraft.m_91087_().m_91291_().m_174269_(tile.getInventory().getStackInSlot(3), ItemTransforms.TransformType.GROUND, light, OverlayTexture.f_118083_, ms, buffer, (int)tile.m_58899_().m_121878_());
            ms.m_85849_();
        }
        if (tile.getProgress() > 0) {
            ms.m_85836_();
            ms.m_85837_(0.3875, 0.29375, 0.3875);
            ms.m_85841_(0.225f, 0.225f, 0.225f);
            float alphaMod = 50000.0f * ((float)tile.getProgress() / (float)tile.getMaxProgress());
            ms.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            ms.m_85837_(0.0, 0.0, (double)-0.1885f);
            float alpha = (float)((Math.sin(((float)ClientTickHandler.ticksInGame + partialTick) / 8.0f) + 1.0) / 5.0 + 0.6) * alphaMod;
            VertexConsumer vertex = buffer.m_6299_(RenderHelper.TERRA_PLATE);
            RenderHelper.renderIcon((PoseStack)ms, (VertexConsumer)vertex, (int)0, (int)0, (TextureAtlasSprite)MiscellaneousModels.INSTANCE.terraPlateOverlay.m_119204_(), (int)1, (int)1, (float)alpha);
            ms.m_85849_();
        }
    }

    private void renderStack(ItemStack stack, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, float partialTick, double progressLeft, float angle, int light) {
        if (!stack.m_41619_()) {
            double progressLeftScaled = progressLeft * 0.95;
            float time = (float)ClientTickHandler.ticksInGame + partialTick;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, (10.4 - 4.0 * progressLeft) / 16.0, 0.5);
            poseStack.m_85841_(0.3f, 0.3f, 0.3f);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(angle + time));
            poseStack.m_85837_(progressLeftScaled * 1.125, 0.0, progressLeftScaled * 0.25);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            poseStack.m_85837_(0.0, 0.075 * Math.sin((double)(time + angle) / 5.0), 0.0);
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, 0);
            poseStack.m_85849_();
        }
    }
}

