/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.base.WorkingTile;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class BlockEntityAlfheimMarket
extends WorkingTile<IElvenTradeRecipe> {
    public static final int MAX_MANA_PER_TICK = 25;
    private final BaseItemStackHandler inventory;
    private ItemStack currentInput = ItemStack.f_41583_;
    private ItemStack currentOutput = ItemStack.f_41583_;

    public BlockEntityAlfheimMarket(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, ModRecipeTypes.ELVEN_TRADE_TYPE, pos, state, LibXServerConfig.MaxManaCapacity.alfheimMarket, 0, 4);
        this.inventory = BaseItemStackHandler.builder((int)5).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.ELVEN_TRADE_TYPE, (ItemStack)stack), new int[]{0, 1, 2, 3}).output(new int[]{4}).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build();
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.runRecipeTick(() -> {
                this.currentInput = ItemStack.f_41583_;
            }, (stack, slot) -> {
                this.currentInput = stack.m_41777_();
            }, (stack, slot) -> {});
            if (this.recipe != null) {
                this.currentOutput = ((IElvenTradeRecipe)this.recipe).getOutputs().size() == 0 ? ItemStack.f_41583_ : ((ItemStack)((IElvenTradeRecipe)this.recipe).getOutputs().get(0)).m_41777_();
                this.m_6596_();
                this.setDispatchable();
            } else if (!this.currentInput.m_41619_() || !this.currentOutput.m_41619_()) {
                this.currentInput = ItemStack.f_41583_;
                this.currentOutput = ItemStack.f_41583_;
                this.m_6596_();
                this.setDispatchable();
            }
            if (this.getCurrentMana() > 0) {
                for (int slot2 = 0; slot2 < 4; ++slot2) {
                    if (this.inventory.getStackInSlot(slot2).m_41720_() != Items.f_42406_) continue;
                    this.f_58857_.m_7731_(this.f_58858_, Blocks.f_50016_.m_49966_(), 3);
                    this.f_58857_.m_46511_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 3.0f, Explosion.BlockInteraction.BREAK);
                    break;
                }
            }
        }
    }

    @Override
    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> slot == 4;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected List<ItemStack> resultItems(IElvenTradeRecipe recipe, List<ItemStack> stacks) {
        return recipe.getOutputs().stream().map(ItemStack::m_41777_).toList();
    }

    @Override
    public int getMaxProgress(IElvenTradeRecipe recipe) {
        return LibXServerConfig.AlfheimMarket.recipeCost;
    }

    @Override
    public int getMaxManaPerTick() {
        return 25 * LibXServerConfig.WorkingDurationMultiplier.alfheimMarket;
    }

    public ItemStack getCurrentInput() {
        return this.currentInput;
    }

    public ItemStack getCurrentOutput() {
        return this.currentOutput;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.currentInput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentInput"));
        this.currentOutput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentOutput"));
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("currentInput", (Tag)this.currentInput.serializeNBT());
        nbt.m_128365_("currentOutput", (Tag)this.currentOutput.serializeNBT());
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return;
        }
        super.handleUpdateTag(nbt);
        this.currentInput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentInput"));
        this.currentOutput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentOutput"));
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("currentInput", (Tag)this.currentInput.serializeNBT());
        nbt.m_128365_("currentOutput", (Tag)this.currentOutput.serializeNBT());
        return nbt;
    }
}

