/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import com.google.common.collect.Range;
import de.melanx.botanicalmachinery.blocks.base.WorkingTile;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.handler.ModSounds;

public class BlockEntityMechanicalApothecary
extends WorkingTile<IPetalRecipe>
implements TickableBlock {
    public static final int WORKING_DURATION = 20;
    public static final int FLUID_CAPACITY = 8000;
    private final BaseItemStackHandler inventory;
    private final ApothecaryFluidTank fluidInventory = new ApothecaryFluidTank(8000, fluidStack -> Fluids.f_76193_.m_6212_(fluidStack.getFluid()));
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.fluidInventory);
    private ItemStack currentOutput = ItemStack.f_41583_;

    public BlockEntityMechanicalApothecary(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, ModRecipeTypes.PETAL_TYPE, pos, state, 0, 1, 17);
        this.inventory = BaseItemStackHandler.builder((int)21).validator(stack -> stack.m_204117_(Tags.Items.SEEDS), new int[]{0}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.PETAL_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(17))).output(new int[]{17, 18, 19, 20}).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build();
    }

    public void tick() {
        block8: {
            block6: {
                block7: {
                    if (this.f_58857_ == null || this.f_58857_.f_46443_) break block6;
                    this.runRecipeTick();
                    if (this.recipe == null) break block7;
                    this.currentOutput = ((IPetalRecipe)this.recipe).m_8043_().m_41777_();
                    this.m_6596_();
                    this.setDispatchable();
                    break block8;
                }
                if (this.currentOutput.m_41619_()) break block8;
                this.currentOutput = ItemStack.f_41583_;
                this.m_6596_();
                this.setDispatchable();
                break block8;
            }
            if (this.f_58857_ != null && LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.mechanicalApothecary && this.fluidInventory.getFluidAmount() > 0) {
                if (this.getMaxProgress() > 0 && this.getProgress() > this.getMaxProgress() - 5) {
                    for (int i = 0; i < 5; ++i) {
                        SparkleParticleData data = SparkleParticleData.sparkle((float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (int)10);
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, (double)this.f_58858_.m_123342_() + 0.6, (double)this.f_58858_.m_123343_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, 0.0, 0.0, 0.0);
                    }
                    this.f_58857_.m_7785_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, ModSounds.altarCraft, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                } else {
                    for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                        ItemStack stack = this.inventory.getStackInSlot(slot);
                        if (stack.m_41619_() || !(this.f_58857_.f_46441_.nextFloat() >= 0.97f)) continue;
                        int color = stack.m_41720_() instanceof ICustomApothecaryColor ? ((ICustomApothecaryColor)stack.m_41720_()).getParticleColor(stack) : 0x888888;
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        if (Math.random() >= 0.75) {
                            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11917_, SoundSource.BLOCKS, 0.1f, 10.0f);
                        }
                        SparkleParticleData data = SparkleParticleData.sparkle((float)this.f_58857_.f_46441_.nextFloat(), (float)red, (float)green, (float)blue, (int)10);
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, (double)this.f_58858_.m_123342_() + 0.6, (double)this.f_58858_.m_123343_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @Override
    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> slot >= 17 && slot <= 20;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    public FluidTank getFluidInventory() {
        return this.fluidInventory;
    }

    @Override
    public boolean actAsMana() {
        return false;
    }

    @Override
    protected int getAndApplyProgressThisTick() {
        return 1;
    }

    @Override
    protected boolean canMatchRecipes() {
        if (this.inventory.getStackInSlot(0).m_41619_()) {
            return false;
        }
        FluidStack fluid = this.getFluidInventory().getFluid();
        return !fluid.isEmpty() && fluid.getFluid() == Fluids.f_76193_ && fluid.getAmount() >= 1000;
    }

    @Override
    protected void onCrafted(IPetalRecipe recipe) {
        this.inventory.extractItem(0, 1, false);
        FluidStack fluid = this.getFluidInventory().getFluid().copy();
        if (fluid.getFluid() != Fluids.f_76193_) {
            return;
        }
        int newAmount = Math.max(0, fluid.getAmount() - 1000);
        fluid.setAmount(newAmount);
        this.fluidInventory.setFluid(fluid);
    }

    @Override
    protected int getMaxProgress(IPetalRecipe recipe) {
        return 20 * LibXServerConfig.WorkingDurationMultiplier.mechanicalApothecary;
    }

    @Override
    public int getMaxManaPerTick() {
        return 1;
    }

    public ItemStack getCurrentOutput() {
        return this.currentOutput;
    }

    @Override
    @Nonnull
    public <X> LazyOptional<X> getCapability(@Nonnull Capability<X> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluidInventory.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid")));
        this.currentOutput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentOutput"));
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag tankTag = new CompoundTag();
        this.getFluidInventory().getFluid().writeToNBT(tankTag);
        nbt.m_128365_("fluid", (Tag)tankTag);
        nbt.m_128365_("currentOutput", (Tag)this.currentOutput.serializeNBT());
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return;
        }
        this.fluidInventory.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid")));
        this.currentOutput = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("currentOutput"));
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        CompoundTag tankTag = new CompoundTag();
        this.getFluidInventory().getFluid().writeToNBT(tankTag);
        nbt.m_128365_("fluid", (Tag)tankTag);
        nbt.m_128365_("currentOutput", (Tag)this.currentOutput.serializeNBT());
        return nbt;
    }

    private class ApothecaryFluidTank
    extends FluidTank {
        public ApothecaryFluidTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            BlockEntityMechanicalApothecary.this.m_6596_();
            BlockEntityMechanicalApothecary.this.setDispatchable();
            BlockEntityMechanicalApothecary.this.needsRecipeUpdate();
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

