/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import de.melanx.botanicalmachinery.blocks.base.WorkingTile;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.lib.ModTags;

public class BlockEntityMechanicalRunicAltar
extends WorkingTile<IRuneAltarRecipe> {
    public static final int MAX_MANA_PER_TICK = 100;
    private final BaseItemStackHandler inventory;
    private final List<Integer> slotsUsed = new ArrayList<Integer>();

    public BlockEntityMechanicalRunicAltar(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, ModRecipeTypes.RUNE_TYPE, pos, state, LibXServerConfig.MaxManaCapacity.mechanicalRunicAltar, 1, 17);
        this.inventory = BaseItemStackHandler.builder((int)33).validator(stack -> stack.m_41720_() == ModBlocks.livingrock.m_5456_(), new int[]{0}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipeTypes.RUNE_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(17))).output(Range.closedOpen((Comparable)Integer.valueOf(17), (Comparable)Integer.valueOf(33))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build();
    }

    @Override
    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> slot >= 17 && slot <= 33;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.runRecipeTick(this.slotsUsed::clear, (stack, slot) -> this.slotsUsed.add((Integer)slot), (stack, slot) -> {});
        } else if (this.f_58857_ != null && LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.industrialAgglomerationFactory && this.getMaxProgress() > 0 && this.getProgress() >= this.getMaxProgress() - 5 * this.getMaxManaPerTick()) {
            for (int i = 0; i < 5; ++i) {
                SparkleParticleData data = SparkleParticleData.sparkle((float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (float)this.f_58857_.f_46441_.nextFloat(), (int)10);
                this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.3 + this.f_58857_.f_46441_.nextDouble() * 0.4, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected boolean canMatchRecipes() {
        return !this.inventory.getStackInSlot(0).m_41619_();
    }

    @Override
    protected List<ItemStack> resultItems(IRuneAltarRecipe recipe, List<ItemStack> stacks) {
        return Streams.concat((Stream[])new Stream[]{stacks.stream().filter(s -> s.m_204117_(ModTags.Items.RUNES)).map(ItemStack::m_41777_), super.resultItems(recipe, stacks).stream()}).toList();
    }

    @Override
    protected void onCrafted(IRuneAltarRecipe recipe) {
        this.inventory.extractItem(0, 1, false);
    }

    @Override
    protected int getMaxProgress(IRuneAltarRecipe recipe) {
        return recipe.getManaUsage();
    }

    @Override
    public int getMaxManaPerTick() {
        return 100 * LibXServerConfig.WorkingDurationMultiplier.mechanicalRunicAltar;
    }

    public boolean isSlotUsedCurrently(int slot) {
        return this.slotsUsed.contains(slot);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.slotsUsed.clear();
        this.slotsUsed.addAll(Arrays.stream(nbt.m_128465_("slotsUsed")).boxed().toList());
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128408_("slotsUsed", this.slotsUsed);
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return;
        }
        this.slotsUsed.clear();
        this.slotsUsed.addAll(Arrays.stream(nbt.m_128465_("slotsUsed")).boxed().toList());
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128408_("slotsUsed", this.slotsUsed);
        return nbt;
    }
}

