/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.core.LibResources;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ManaBar {
    private final Screen parent;
    public int x = 153;
    public int y = 15;
    public final int capacity;
    private final int width = 16;
    private final int height = 62;
    public int guiLeft;
    public int guiTop;

    public ManaBar(Screen parent, int capacity) {
        this.parent = parent;
        this.capacity = capacity;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.guiLeft + this.x < mouseX && mouseX < this.guiLeft + this.x + this.width && this.guiTop + this.y < mouseY && mouseY < this.guiTop + this.y + this.height;
    }

    public void draw(PoseStack ms, float mana) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)LibResources.MANA_BAR);
        int relX = this.guiLeft + this.x;
        int relY = this.guiTop + this.y;
        Screen.m_93133_((PoseStack)ms, (int)relX, (int)relY, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        RenderSystem.m_157456_((int)0, (ResourceLocation)LibResources.MANA_BAR_CURRENT);
        float pct = Math.min(mana / (float)this.capacity, 1.0f);
        int relHeight = (int)((float)(this.height - 2) * pct);
        Screen.m_93133_((PoseStack)ms, (int)(++relX), (int)(++relY + (this.height - 2 - relHeight)), (float)0.0f, (float)0.0f, (int)(this.width - 2), (int)relHeight, (int)(this.width - 2), (int)(this.height - 2));
    }

    public void renderHoveredToolTip(PoseStack ms, int mouseX, int mouseY, int mana) {
        if (this.isMouseOver(mouseX, mouseY) && LibXClientConfig.numericalMana) {
            TranslatableComponent text = new TranslatableComponent("%s / %s Mana", new Object[]{mana, this.capacity});
            this.parent.m_96602_(ms, (Component)text, mouseX, mouseY);
        }
    }
}

