/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering;

import blusunrize.immersiveengineering.api.IETags;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.bus.LineAccessBlockEntity;
import malte0811.controlengineering.blockentity.bus.RSRemapperBlockEntity;
import malte0811.controlengineering.blocks.shapes.SelectionShapeOwner;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.items.IEItemRefs;
import malte0811.controlengineering.items.PCBStackItem;
import malte0811.controlengineering.util.RaytraceUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="controlengineering", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    @SubscribeEvent
    public static void renderSelectionShape(DrawSelectionEvent.HighlightBlock ev) {
        BlockHitResult target = ev.getTarget();
        BlockPos highlighted = target.m_82425_();
        List<? extends SelectionShapes> selectedStack = ClientEvents.getSelectedStack();
        if (selectedStack != null) {
            int i;
            PoseStack transform = ev.getPoseStack();
            transform.m_85836_();
            Vec3 projectedView = Vec3.m_82528_((Vec3i)highlighted).m_82546_(ev.getCamera().m_90583_());
            transform.m_85837_(projectedView.f_82479_, projectedView.f_82480_, projectedView.f_82481_);
            VertexConsumer builder = ev.getMultiBufferSource().m_6299_(RenderType.m_110504_());
            int pushCount = selectedStack.size() - 1;
            for (i = 0; i < pushCount; ++i) {
                SelectionShapes nonTopShape = selectedStack.get(i);
                if (nonTopShape.shouldRenderNonTop()) {
                    ClientEvents.renderShape(transform, nonTopShape, builder);
                }
                Matrix4f inverse = nonTopShape.outerToInnerPosition().m_27658_();
                inverse.m_27657_();
                new Transformation(inverse).push(transform);
            }
            ClientEvents.renderShape(transform, selectedStack.get(pushCount), builder);
            for (i = 0; i < pushCount; ++i) {
                transform.m_85849_();
            }
            transform.m_85849_();
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlayPost(RenderGameOverlayEvent.Post event) {
        List<? extends SelectionShapes> shapeStack;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack held = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        ArrayList<Component> lines = new ArrayList<Component>();
        BlockPos pos = hitResult2.m_82425_();
        BlockEntity targetBE = mc.f_91074_.f_19853_.m_7702_(pos);
        if (held.m_204117_(IETags.screwdrivers)) {
            if (targetBE instanceof LineAccessBlockEntity) {
                LineAccessBlockEntity access = (LineAccessBlockEntity)targetBE;
                lines.add((Component)new TranslatableComponent("controlengineering.gui.lineIndex", new Object[]{access.selectedLine}));
            } else if (targetBE instanceof RSRemapperBlockEntity) {
                RSRemapperBlockEntity remapper = (RSRemapperBlockEntity)targetBE;
                remapper.addOverlay(lines, hitResult2);
            }
        }
        if ((shapeStack = ClientEvents.getSelectedStack()) != null) {
            for (int i = shapeStack.size() - 1; i >= 0; --i) {
                Component line = shapeStack.get(i).getOverlayText();
                if (line == null) continue;
                lines.add(line);
            }
        }
        for (int i = 0; i < lines.size(); ++i) {
            Font font = mc.f_91062_;
            PoseStack poseStack = event.getMatrixStack();
            Component component = (Component)lines.get(i);
            float f = (float)mc.m_91268_().m_85445_() / 2.0f + 8.0f;
            float f2 = (float)mc.m_91268_().m_85446_() / 2.0f + 8.0f;
            Objects.requireNonNull(mc.f_91062_);
            font.m_92889_(poseStack, component, f, f2 + (float)(i * (9 + 2)), -1);
        }
    }

    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent ev) {
        if (ev.getItemStack().m_150930_(IEItemRefs.LOGIC_CIRCUIT.m_5456_())) {
            ev.getToolTip().add(PCBStackItem.useIn(IEItemRefs.LOGIC_UNIT));
        }
    }

    private static void renderShape(PoseStack transform, SelectionShapes shape, VertexConsumer builder) {
        shape.plotBox((v1, v2) -> {
            Vec3 normal = v2.m_82546_(v1);
            Matrix4f poseMatrix = transform.m_85850_().m_85861_();
            Matrix3f normalMatrix = transform.m_85850_().m_85864_();
            ClientEvents.addPoint(builder, poseMatrix, normalMatrix, v1, normal);
            ClientEvents.addPoint(builder, poseMatrix, normalMatrix, v2, normal);
        });
    }

    private static void addPoint(VertexConsumer builder, Matrix4f transform, Matrix3f normalTransform, Vec3 pos, Vec3 normal) {
        builder.m_85982_(transform, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_85977_(normalTransform, (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    @Nullable
    private static List<? extends SelectionShapes> getSelectedStack() {
        SelectionShapeOwner shapeOwner;
        List selectedStack;
        Minecraft mc = Minecraft.m_91087_();
        HitResult mop = mc.f_91077_;
        if (!(mop instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult target = (BlockHitResult)mop;
        BlockPos highlighted = target.m_82425_();
        ClientLevel world = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        if (world == null || player == null) {
            return null;
        }
        BlockEntity blockEntity = world.m_7702_(highlighted);
        if (blockEntity instanceof SelectionShapeOwner && !(selectedStack = (List)(shapeOwner = (SelectionShapeOwner)blockEntity).getShape().getTargeted(RaytraceUtils.create((Player)player, mc.m_91296_(), Vec3.m_82528_((Vec3i)highlighted))).getFirst()).isEmpty()) {
            return selectedStack;
        }
        return null;
    }
}

