/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.bus;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.lang.ref.WeakReference;
import java.util.Collection;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.CEIICBlockEntity;
import malte0811.controlengineering.blockentity.base.INeighborChangeListener;
import malte0811.controlengineering.blocks.bus.BusInterfaceBlock;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.bus.IBusConnector;
import malte0811.controlengineering.bus.IBusInterface;
import malte0811.controlengineering.bus.LocalBusHandler;
import malte0811.controlengineering.util.Clearable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BusInterfaceBlockEntity
extends CEIICBlockEntity
implements IBusConnector,
INeighborChangeListener {
    private Pair<WeakReference<IBusInterface>, Runnable> clearer = null;

    public BusInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onBusUpdated(ConnectionPoint updatedPoint) {
        IBusInterface connected = this.getConnectedBE();
        if (connected != null) {
            LocalBusHandler handler = this.getBusHandler(updatedPoint);
            connected.onBusUpdated(handler.getState(), handler.getStateWithout(updatedPoint, this));
        }
    }

    @Override
    public BusState getEmittedState(ConnectionPoint checkedPoint) {
        IBusInterface connected = this.getConnectedBE();
        if (connected != null) {
            return connected.getEmittedState();
        }
        return BusState.EMPTY;
    }

    @Override
    public LocalWireNetwork getLocalNet(int cpIndex) {
        return this.globalNet.getLocalNet(this.f_58858_);
    }

    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        return new Vec3(0.5, 0.5, 0.5).m_82549_(Vec3.m_82528_((Vec3i)this.getFacing().m_122436_()).m_82490_(0.0625));
    }

    @Nullable
    private IBusInterface getConnectedBE() {
        IBusInterface busInterface;
        Direction facing = this.getFacing();
        BlockEntity neighbor = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing));
        if (neighbor instanceof IBusInterface && (busInterface = (IBusInterface)neighbor).canConnect(facing.m_122424_())) {
            if (this.clearer == null || ((WeakReference)this.clearer.getFirst()).get() != busInterface) {
                Pair<Clearable<Runnable>, Runnable> newClearer = Clearable.create(() -> {
                    LocalBusHandler handler = this.getBusHandler(new ConnectionPoint(this.f_58858_, 0));
                    if (handler != null) {
                        handler.requestUpdate();
                    }
                });
                busInterface.addMarkDirtyCallback((Clearable)newClearer.getFirst());
                this.clearer = Pair.of(new WeakReference<IBusInterface>(busInterface), (Object)((Runnable)newClearer.getSecond()));
                ((Runnable)((Clearable)newClearer.getFirst()).getValue()).run();
            }
            return busInterface;
        }
        return null;
    }

    private Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_(BusInterfaceBlock.FACING);
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)LocalBusHandler.NAME);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.clearer != null) {
            ((Runnable)this.clearer.getSecond()).run();
        }
    }

    @Override
    public void onNeighborChanged(BlockPos neighbor) {
        this.getBusHandler(new ConnectionPoint(this.f_58858_, 0)).requestUpdate();
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.m_5776_()) {
            ApiUtils.addFutureServerTask((Level)this.f_58857_, this::getConnectedBE, (boolean)true);
        }
    }
}

