/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.bus;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import malte0811.controlengineering.blockentity.CEIICBlockEntity;
import malte0811.controlengineering.blocks.bus.LineAccessBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class DualConnectorBlockEntity
extends CEIICBlockEntity {
    protected static final int MIN_ID = 0;
    protected static final int MAX_ID = 1;
    protected final ConnectionPoint minPoint;
    protected final ConnectionPoint maxPoint;

    public DualConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.minPoint = new ConnectionPoint(this.f_58858_, 0);
        this.maxPoint = new ConnectionPoint(this.f_58858_, 1);
    }

    public final Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        double offset = here.index() == 1 ? 0.25 : -0.25;
        return new Vec3(0.5, 0.4375, 0.5).m_82549_(Vec3.m_82528_((Vec3i)((Direction)this.m_58900_().m_61143_(LineAccessBlock.FACING)).m_122436_()).m_82490_(offset));
    }

    @Override
    @Nonnull
    public final ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        Direction facing = (Direction)this.m_58900_().m_61143_(LineAccessBlock.FACING);
        Vec3i normal = facing.m_122436_();
        if ((double)normal.m_123341_() * ((double)info.hitX - 0.5) + (double)normal.m_123342_() * ((double)info.hitY - 0.5) + (double)normal.m_123343_() * ((double)info.hitZ - 0.5) < 0.0) {
            return this.minPoint;
        }
        return this.maxPoint;
    }

    @Override
    public final Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)this.maxPoint, (Object)this.minPoint);
    }

    protected final ConnectionPoint getOtherPoint(ConnectionPoint cp) {
        return cp.equals((Object)this.maxPoint) ? this.minPoint : this.maxPoint;
    }
}

