/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.bus;

import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.bus.DualConnectorBlockEntity;
import malte0811.controlengineering.bus.BusLine;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.bus.IBusConnector;
import malte0811.controlengineering.bus.LocalBusHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LineAccessBlockEntity
extends DualConnectorBlockEntity
implements IBusConnector,
IRedstoneConnector {
    private static final int REDSTONE_ID = 0;
    private static final int BUS_ID = 1;
    public int selectedLine;
    private BusLine lastLineToRS = new BusLine();

    public LineAccessBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.selectedLine = nbt.m_128451_("selectedLine");
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("selectedLine", this.selectedLine);
    }

    @Override
    public void onBusUpdated(ConnectionPoint updatedPoint) {
        RedstoneNetworkHandler rsHandler = this.getRSNet();
        BusLine lineToRS = this.getBusNet().getStateWithout(this.getBusPoint(), this).getLine(this.selectedLine);
        if (rsHandler != null && !this.lastLineToRS.equals(lineToRS)) {
            rsHandler.updateValues();
            this.lastLineToRS = lineToRS;
        }
    }

    @Override
    public BusState getEmittedState(ConnectionPoint checkedPoint) {
        BusState ret = BusState.EMPTY;
        RedstoneNetworkHandler rs = this.getRSNet();
        if (rs != null) {
            ret = ret.withLine(this.selectedLine, BusLine.fromRSState(rs.getValuesExcluding(this.getRedstonePoint())));
        }
        return ret;
    }

    @Override
    public LocalWireNetwork getLocalNet(int cpIndex) {
        return super.getLocalNet(cpIndex);
    }

    @Override
    public boolean canConnectCable(WireType wireType, ConnectionPoint connectionPoint, Vec3i offset) {
        if (this.countRealWiresAt(connectionPoint) > 0) {
            return false;
        }
        if (connectionPoint.index() == 1) {
            return IBusConnector.super.canConnectCable(wireType, connectionPoint, offset);
        }
        return wireType.getCategory().equals("REDSTONE");
    }

    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (this.getRedstonePoint().equals((Object)cp)) {
            this.getBusNet().requestUpdate();
        }
    }

    public void updateInput(byte[] signals, ConnectionPoint cp) {
        if (this.getRedstonePoint().equals((Object)cp)) {
            BusLine line = this.getBusNet().getStateWithout(this.getBusPoint(), this).getLine(this.selectedLine);
            for (int i = 0; i < signals.length; ++i) {
                signals[i] = (byte)Math.max(line.getRSValue(i), signals[i]);
            }
        }
    }

    @Nullable
    private RedstoneNetworkHandler getRSNet() {
        return (RedstoneNetworkHandler)this.getLocalNet(0).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class);
    }

    private LocalBusHandler getBusNet() {
        return Objects.requireNonNull(this.getBusHandler(this.getBusPoint()));
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)LocalBusHandler.NAME, (Object)RedstoneNetworkHandler.ID);
    }

    @Override
    public boolean isBusPoint(ConnectionPoint cp) {
        return this.getBusPoint().equals((Object)cp);
    }

    private ConnectionPoint getRedstonePoint() {
        return this.minPoint;
    }

    private ConnectionPoint getBusPoint() {
        return this.maxPoint;
    }
}

