/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.bus;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import java.util.Optional;
import malte0811.controlengineering.bus.BusLine;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.util.BitUtils;
import net.minecraft.nbt.CompoundTag;

public class ParallelPort {
    private static final int BUS_LINE = 0;
    private static final int CLOCK_INDEX = 8;
    private final ByteList transmitQueue;
    private boolean sendingFirst;
    private byte currentInput;
    private boolean lastTriggerHigh;
    private boolean triggerHigh;

    public ParallelPort() {
        this.transmitQueue = new ByteArrayList();
    }

    public ParallelPort(CompoundTag nbt) {
        this.transmitQueue = new ByteArrayList(nbt.m_128463_("remotePrintQueue"));
        this.sendingFirst = nbt.m_128471_("sendingFirst");
        this.currentInput = nbt.m_128445_("currentInput");
        this.triggerHigh = nbt.m_128471_("triggerHigh");
        this.lastTriggerHigh = nbt.m_128471_("lastTriggerHigh");
    }

    public boolean tickTX() {
        boolean updateRS = false;
        if (this.sendingFirst && !this.transmitQueue.isEmpty()) {
            this.transmitQueue.removeByte(0);
            this.sendingFirst = false;
            updateRS = true;
        } else if (!this.transmitQueue.isEmpty()) {
            this.sendingFirst = true;
            updateRS = true;
        }
        return updateRS;
    }

    public Optional<Byte> tickRX() {
        Optional<Byte> result = this.triggerHigh && !this.lastTriggerHigh ? Optional.of(this.currentInput) : Optional.empty();
        this.lastTriggerHigh = this.triggerHigh;
        return result;
    }

    public BusState getOutputState() {
        if (!this.sendingFirst || this.transmitQueue.isEmpty()) {
            return BusState.EMPTY;
        }
        byte toSend = this.transmitQueue.getByte(0);
        int[] line = new int[16];
        for (int i = 0; i < 8; ++i) {
            line[i] = BitUtils.getBit(toSend, i) ? 255 : 0;
        }
        line[8] = 255;
        return BusState.EMPTY.withLine(0, new BusLine(line));
    }

    public void onBusStateChange(BusState inputState) {
        this.triggerHigh = inputState.getLine(0).getValue(8) != 0;
        this.currentInput = 0;
        for (int i = 0; i < 8; ++i) {
            if (inputState.getLine(0).getValue(i) == 0) continue;
            this.currentInput = (byte)(this.currentInput | 1 << i);
        }
    }

    public CompoundTag toNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128382_("remotePrintQueue", this.transmitQueue.toByteArray());
        result.m_128379_("sendingFirst", this.sendingFirst);
        result.m_128344_("currentInput", this.currentInput);
        result.m_128379_("triggerHigh", this.triggerHigh);
        result.m_128379_("lastTriggerHigh", this.lastTriggerHigh);
        return result;
    }

    public void queueChar(byte out) {
        this.transmitQueue.add(out);
    }

    public void queueStringWithParity(String message) {
        for (byte b : message.getBytes()) {
            this.queueChar(BitUtils.fixParity(b));
        }
    }
}

