/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.bus;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.bus.DualConnectorBlockEntity;
import malte0811.controlengineering.bus.LocalBusHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RSRemapperBlockEntity
extends DualConnectorBlockEntity
implements IRedstoneConnector {
    private static final int COLOR_ID = 0;
    public static final int NOT_MAPPED = 17;
    public static final String COLORED_KEY = "controlengineering.gui.remapper.colored";
    public static final String GRAY_KEY = "controlengineering.gui.remapper.gray";
    private int[] colorToGray = RSRemapperBlockEntity.makeInitialMapping();
    private int[] grayToColor = RSRemapperBlockEntity.makeInverseMapping(this.colorToGray);
    private final byte[][] lastInputByPoint = new byte[2][16];
    private final boolean[] needsUpdate = new boolean[]{false, false};

    public RSRemapperBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        int[] newColorToGray = nbt.m_128465_("colorToGray");
        if (newColorToGray.length != 16) {
            newColorToGray = RSRemapperBlockEntity.makeInitialMapping();
        }
        this.setColorToGray(newColorToGray);
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128385_("colorToGray", this.colorToGray);
    }

    public LocalWireNetwork getLocalNet(int cpIndex) {
        return super.getLocalNet(cpIndex);
    }

    public boolean canConnectCable(WireType wireType, ConnectionPoint connectionPoint, Vec3i offset) {
        return this.countRealWiresAt(connectionPoint) == 0 && wireType.getCategory().equals("REDSTONE");
    }

    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        RedstoneNetworkHandler netHere = this.getNet(cp);
        if (netHere == null) {
            return;
        }
        RedstoneNetworkHandler netOther = this.getOtherNet(cp);
        if (netOther == null || netOther == netHere && cp.index() != 0) {
            return;
        }
        byte[] inputSignals = netHere.getValuesExcluding(cp);
        if (Arrays.equals(inputSignals, this.lastInputByPoint[cp.index()])) {
            return;
        }
        System.arraycopy(inputSignals, 0, this.lastInputByPoint[cp.index()], 0, 16);
        this.needsUpdate[1 - cp.index()] = true;
        Objects.requireNonNull(this.f_58857_).m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 1);
    }

    public void updateInput(byte[] signals, ConnectionPoint cp) {
        RedstoneNetworkHandler otherNet = this.getOtherNet(cp);
        RedstoneNetworkHandler thisNet = this.getNet(cp);
        if (otherNet == null || thisNet == null) {
            return;
        }
        if (otherNet == thisNet) {
            this.updateInputsShorted(signals, cp);
            return;
        }
        int[] otherToThis = cp.index() == 0 ? this.grayToColor : this.colorToGray;
        byte[] inputs = this.lastInputByPoint[1 - cp.index()];
        for (int otherIndex = 0; otherIndex < inputs.length; ++otherIndex) {
            int thisIndex = otherToThis[otherIndex];
            if (thisIndex == 17) continue;
            signals[thisIndex] = (byte)Math.max(inputs[otherIndex], signals[thisIndex]);
        }
    }

    public void onBlockTick() {
        for (int i = 0; i < 2; ++i) {
            if (!this.needsUpdate[i]) continue;
            RedstoneNetworkHandler net = this.getNet(new ConnectionPoint(this.f_58858_, i));
            if (net != null) {
                net.updateValues();
            }
            this.needsUpdate[i] = false;
        }
    }

    private void updateInputsShorted(byte[] out, ConnectionPoint cp) {
        boolean changed;
        if (cp.index() != 0) {
            return;
        }
        byte[] totalSignal = Arrays.copyOf(this.lastInputByPoint[0], 16);
        do {
            changed = false;
            for (int[] mapping : List.of(this.colorToGray, this.grayToColor)) {
                for (int i = 0; i < 16; ++i) {
                    int outIndex = mapping[i];
                    if (outIndex == 17 || totalSignal[i] <= out[outIndex]) continue;
                    totalSignal[outIndex] = out[outIndex] = totalSignal[i];
                    changed = true;
                }
            }
        } while (changed);
    }

    @Nullable
    private RedstoneNetworkHandler getOtherNet(ConnectionPoint cp) {
        return this.getNet(this.getOtherPoint(cp));
    }

    @Nullable
    private RedstoneNetworkHandler getNet(ConnectionPoint cp) {
        return (RedstoneNetworkHandler)this.getLocalNet(cp).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class);
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)LocalBusHandler.NAME, (Object)RedstoneNetworkHandler.ID);
    }

    public int[] getColorToGray() {
        return this.colorToGray;
    }

    public void setColorToGray(int[] newColorToGray) {
        this.colorToGray = newColorToGray;
        this.grayToColor = RSRemapperBlockEntity.makeInverseMapping(this.colorToGray);
    }

    private static int[] makeInitialMapping() {
        int[] result = new int[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = i;
        }
        return result;
    }

    private static int[] makeInverseMapping(int[] mapping) {
        int[] result = new int[mapping.length];
        Arrays.fill(result, 17);
        for (int i = 0; i < mapping.length; ++i) {
            if (mapping[i] >= result.length) continue;
            result[mapping[i]] = i;
        }
        return result;
    }

    public void addOverlay(List<Component> lines, BlockHitResult hitResult) {
        Vec3 hitLoc = hitResult.m_82450_().m_82492_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        ConnectionPoint target = this.getTargetedPoint(new TargetingInfo(hitResult.m_82434_(), (float)hitLoc.f_82479_, (float)hitLoc.f_82480_, (float)hitLoc.f_82481_), Vec3i.f_123288_);
        lines.add((Component)new TranslatableComponent(target.index() == 0 ? COLORED_KEY : GRAY_KEY));
    }
}

