/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.logic;

import java.util.Objects;
import java.util.function.Consumer;
import malte0811.controlengineering.util.ItemUtil;
import malte0811.controlengineering.util.LambdaMutable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.Mutable;

public class CircuitIngredientDrawer {
    private static final int CAPACITY = 256;
    private static final String ITEM_KEY = "storedType";
    private static final String COUNT_KEY = "storedCount";
    private final TagKey<Item> filter;
    private final String emptyKey;
    private ItemStack storedType = ItemStack.f_41583_;
    private int storedCount = 0;

    public CircuitIngredientDrawer(TagKey<Item> filter, String emptyKey) {
        this.filter = filter;
        this.emptyKey = emptyKey;
    }

    public InteractionResult interact(UseOnContext ctx) {
        ItemStack held = ctx.m_43722_();
        if (held.m_204117_(this.filter) && CircuitIngredientDrawer.canCombine(this.storedType, held)) {
            if (!ctx.m_43725_().f_46443_) {
                int toAdd = Math.min(held.m_41613_(), 256 - this.storedCount);
                if (this.storedType.m_41619_()) {
                    this.storedType = held.m_41777_();
                    this.storedCount = toAdd;
                } else {
                    this.storedCount += toAdd;
                }
                held.m_41774_(toAdd);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.storedType.m_41619_() && ctx.m_43723_() != null) {
            if (!ctx.m_43725_().f_46443_) {
                int count = Math.min(this.storedCount, this.storedType.m_41741_());
                ItemUtil.giveOrDrop(ctx.m_43723_(), ItemHandlerHelper.copyStackWithSize((ItemStack)this.storedType, (int)count));
                this.consume(count);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean canCombine(ItemStack existing, ItemStack added) {
        if (existing.m_41619_()) {
            return true;
        }
        if (added.m_41720_() != existing.m_41720_()) {
            return false;
        }
        if (!existing.areCapsCompatible((CapabilityProvider)added)) {
            return false;
        }
        return Objects.equals(added.m_41783_(), existing.m_41783_());
    }

    public boolean canConsume(int required) {
        return this.storedCount >= required;
    }

    public void consume(int required) {
        this.storedCount -= required;
        if (this.storedCount <= 0) {
            this.clear();
        }
    }

    public Mutable<BigItemStack> getStoredRef() {
        return new LambdaMutable<BigItemStack>(this::getStored, newContent -> {
            this.storedType = newContent.type();
            this.storedCount = newContent.count();
        });
    }

    public BigItemStack getStored() {
        return new BigItemStack(this.storedType.m_41777_(), this.storedCount);
    }

    public void clear() {
        this.storedType = ItemStack.f_41583_;
        this.storedCount = 0;
    }

    public void read(CompoundTag nbt) {
        if (!nbt.m_128425_(COUNT_KEY, 3)) {
            ItemStack contentStack = ItemStack.m_41712_((CompoundTag)nbt);
            this.storedCount = contentStack.m_41613_();
            this.storedType = contentStack.m_41619_() ? ItemStack.f_41583_ : ItemHandlerHelper.copyStackWithSize((ItemStack)contentStack, (int)1);
        } else {
            this.storedType = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(ITEM_KEY));
            this.storedCount = nbt.m_128451_(COUNT_KEY);
        }
    }

    public CompoundTag write() {
        CompoundTag result = new CompoundTag();
        result.m_128365_(ITEM_KEY, (Tag)this.storedType.m_41739_(new CompoundTag()));
        result.m_128405_(COUNT_KEY, this.storedCount);
        return result;
    }

    public String getEmptyKey() {
        return this.emptyKey;
    }

    public void drop(Consumer<ItemStack> dropper) {
        while (this.storedCount > 0) {
            int count = Math.min(this.storedCount, this.storedType.m_41741_());
            dropper.accept(ItemHandlerHelper.copyStackWithSize((ItemStack)this.storedType, (int)count));
            this.consume(count);
        }
        this.clear();
    }

    public record BigItemStack(ItemStack type, int count) {
        public static final BigItemStack EMPTY = new BigItemStack(ItemStack.f_41583_, 0);
    }
}

