/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.logic;

import javax.annotation.Nonnull;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.logic.clock.ClockGenerator;
import malte0811.controlengineering.logic.clock.ClockTypes;
import malte0811.controlengineering.util.ItemUtil;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class ClockSlot {
    @Nonnull
    private ClockGenerator.ClockInstance<?> clock = (ClockGenerator.ClockInstance)ClockTypes.NEVER.newInstance();

    public InteractionResult click(UseOnContext ctx, Runnable onSuccess) {
        if (ctx.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        ClockGenerator currentClock = (ClockGenerator)this.clock.getType();
        RegistryObject<Item> clockItem = CEItems.CLOCK_GENERATORS.get(currentClock.getRegistryName());
        if (!ctx.m_43725_().f_46443_) {
            if (clockItem != null) {
                ItemUtil.giveOrDrop(ctx.m_43723_(), new ItemStack((ItemLike)clockItem.get()));
                this.clock = (ClockGenerator.ClockInstance)ClockTypes.NEVER.newInstance();
                onSuccess.run();
            } else {
                ItemStack item = ctx.m_43722_();
                ClockGenerator<?> newClock = ClockTypes.REGISTRY.get(item.m_41720_().getRegistryName());
                if (newClock != null) {
                    this.clock = (ClockGenerator.ClockInstance)newClock.newInstance();
                    item.m_41774_(1);
                    onSuccess.run();
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public ClockGenerator.ClockInstance<?> getClock() {
        return this.clock;
    }

    public ClockGenerator<?> getType() {
        return (ClockGenerator)this.clock.getType();
    }

    public boolean isPresent() {
        return ((ClockGenerator)this.clock.getType()).isActiveClock();
    }

    public void load(Tag data) {
        this.clock = ClockGenerator.ClockInstance.CODEC.fromNBT(data, ClockTypes.NEVER::newInstance);
    }

    public Tag toNBT() {
        return ClockGenerator.ClockInstance.CODEC.toNBT(this.clock);
    }

    public Tag toClientNBT() {
        return ByteTag.m_128273_((boolean)this.isPresent());
    }

    public void loadClientNBT(Tag data) {
        ByteTag byteTag;
        this.clock = data instanceof ByteTag && (byteTag = (ByteTag)data).m_7063_() != 0 ? (ClockGenerator.ClockInstance)ClockTypes.ALWAYS_ON.newInstance() : (ClockGenerator.ClockInstance)ClockTypes.NEVER.newInstance();
    }
}

