/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.logic;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.base.CEBlockEntity;
import malte0811.controlengineering.blockentity.base.IExtraDropBE;
import malte0811.controlengineering.blockentity.base.IHasMaster;
import malte0811.controlengineering.blockentity.logic.ClockSlot;
import malte0811.controlengineering.blockentity.logic.ISchematicBE;
import malte0811.controlengineering.blocks.logic.LogicCabinetBlock;
import malte0811.controlengineering.blocks.shapes.DirectionalShapeProvider;
import malte0811.controlengineering.blocks.shapes.ListShapes;
import malte0811.controlengineering.blocks.shapes.SelectionShapeOwner;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.blocks.shapes.SingleShape;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.bus.IBusInterface;
import malte0811.controlengineering.bus.MarkDirtyHandler;
import malte0811.controlengineering.client.model.logic.DynamicLogicModel;
import malte0811.controlengineering.gui.CEContainers;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.items.PCBStackItem;
import malte0811.controlengineering.logic.cells.LeafcellInstance;
import malte0811.controlengineering.logic.circuit.BusConnectedCircuit;
import malte0811.controlengineering.logic.circuit.Circuit;
import malte0811.controlengineering.logic.schematic.Schematic;
import malte0811.controlengineering.logic.schematic.SchematicCircuitConverter;
import malte0811.controlengineering.logic.schematic.symbol.CellSymbol;
import malte0811.controlengineering.logic.schematic.symbol.PlacedSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.util.BEUtil;
import malte0811.controlengineering.util.CachedValue;
import malte0811.controlengineering.util.Clearable;
import malte0811.controlengineering.util.ItemUtil;
import malte0811.controlengineering.util.ShapeUtils;
import malte0811.controlengineering.util.energy.CEEnergyStorage;
import malte0811.controlengineering.util.math.MatrixUtils;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;

public class LogicCabinetBlockEntity
extends CEBlockEntity
implements SelectionShapeOwner,
IBusInterface,
ISchematicBE,
IExtraDropBE,
IHasMaster<LogicCabinetBlockEntity> {
    public static final int MAX_NUM_BOARDS = 4;
    public static final int LOGIC_TUBE_PER_RENDER_TUBES = 2;
    public static final int NUM_TUBES_PER_BOARD = 16;
    private static final MyCodec<Pair<Schematic, BusConnectedCircuit>> CIRCUIT_CODEC = MyCodecs.pair(Schematic.CODEC, BusConnectedCircuit.CODEC);
    private final CEEnergyStorage energy = new CEEnergyStorage(2048, 256, 128);
    @Nullable
    private Pair<Schematic, BusConnectedCircuit> circuit;
    private final ClockSlot clock = new ClockSlot();
    private final MarkDirtyHandler markBusDirty = new MarkDirtyHandler();
    private int numRenderTubes = -1;
    private BusState currentBusState = BusState.EMPTY;
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(this.energy::insertOnlyView);
    private final CachedValue<BlockState, SelectionShapes> selectionShapes = new CachedValue<BlockState, SelectionShapes>(() -> ((LogicCabinetBlockEntity)this).m_58900_(), state -> LogicCabinetBlockEntity.createSelectionShapes(LogicCabinetBlockEntity.getFacing(state), this.computeMasterBE((BlockState)state), LogicCabinetBlockEntity.isUpper(state), (Boolean)state.m_61143_((Property)LogicCabinetBlock.NOT_MIRRORED) == false));

    public LogicCabinetBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state2) {
        super(type, pos, state2);
    }

    public static int getNumBoardsFor(int numLogicTubes) {
        if (numLogicTubes <= 0) {
            return 1;
        }
        return Mth.m_14165_((double)((double)numLogicTubes / 32.0));
    }

    public void tick() {
        boolean rsIn;
        if (this.circuit == null || this.energy.extractOrTrue(64) || this.f_58857_.m_46467_() % 2L != 0L) {
            return;
        }
        Direction clockFace = this.getRotatedDirection(true);
        boolean bl = rsIn = this.f_58857_.m_46681_(this.f_58858_.m_142300_(clockFace), clockFace) > 0;
        if (!this.clock.getClock().tick(rsIn)) {
            return;
        }
        if (((BusConnectedCircuit)this.circuit.getSecond()).tick()) {
            this.markBusDirty.run();
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.clock.load(nbt.m_128423_("clock"));
        if (nbt.m_128441_("circuit")) {
            this.setSchematicAndComputeCircuit(Schematic.CODEC.fromNBT(nbt.m_128423_("circuit")));
        } else {
            this.setCircuit(CIRCUIT_CODEC.fromNBT(nbt.m_128423_("schematicAndCircuit")));
        }
        this.energy.readNBT(nbt.m_128423_("energy"));
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("clock", this.clock.toNBT());
        if (this.circuit != null) {
            compound.m_128365_("schematicAndCircuit", CIRCUIT_CODEC.toNBT(this.circuit));
        }
        compound.m_128365_("energy", this.energy.writeNBT());
    }

    @Override
    protected void writeSyncedData(CompoundTag result) {
        result.m_128365_("hasClock", this.clock.toClientNBT());
        result.m_128405_("numTubes", this.numRenderTubes);
    }

    @Override
    protected void readSyncedData(CompoundTag tag) {
        this.clock.loadClientNBT(tag.m_128423_("hasClock"));
        this.numRenderTubes = tag.m_128451_("numTubes");
        this.requestModelDataUpdate();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Nonnull
    public IModelData getModelData() {
        return new SinglePropertyModelData((Object)new DynamicLogicModel.ModelData(this.numRenderTubes, this.clock.isPresent()), DynamicLogicModel.DATA);
    }

    @Override
    public void onBusUpdated(BusState totalState, BusState otherState) {
        if (this.circuit != null) {
            ((BusConnectedCircuit)this.circuit.getSecond()).updateInputs(totalState);
        }
        this.currentBusState = totalState;
    }

    @Override
    public BusState getEmittedState() {
        if (this.circuit != null) {
            return ((BusConnectedCircuit)this.circuit.getSecond()).getOutputState();
        }
        return BusState.EMPTY;
    }

    @Override
    public boolean canConnect(Direction fromSide) {
        return fromSide == this.getRotatedDirection(false);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && side == LogicCabinetBlockEntity.getFacing(this.m_58900_())) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCap.invalidate();
    }

    @Override
    public void addMarkDirtyCallback(Clearable<Runnable> markDirty) {
        this.markBusDirty.addCallback(markDirty);
    }

    public void m_7651_() {
        super.m_7651_();
        this.markBusDirty.run();
    }

    private void setCircuit(@Nullable Pair<Schematic, BusConnectedCircuit> circuit) {
        this.circuit = circuit;
        if (circuit != null) {
            this.numRenderTubes = Mth.m_14165_((double)((double)((Schematic)circuit.getFirst()).getNumLogicTubes() / 2.0));
            ((BusConnectedCircuit)circuit.getSecond()).updateInputs(this.currentBusState);
        } else {
            this.numRenderTubes = -1;
        }
    }

    public void setSchematicAndComputeCircuit(@Nonnull Schematic schematic) {
        Optional<BusConnectedCircuit> busCircuit = SchematicCircuitConverter.toCircuit(schematic);
        if (busCircuit.isPresent()) {
            this.setCircuit((Pair<Schematic, BusConnectedCircuit>)Pair.of((Object)schematic, (Object)busCircuit.get()));
        } else {
            this.setCircuit(null);
        }
    }

    private static Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)LogicCabinetBlock.FACING);
    }

    private Direction getRotatedDirection(boolean leftIfNonMirrored) {
        Direction facing = LogicCabinetBlockEntity.getFacing(this.m_58900_());
        Boolean mirrored = (Boolean)this.m_58900_().m_61143_((Property)LogicCabinetBlock.NOT_MIRRORED);
        return mirrored != leftIfNonMirrored ? facing.m_122427_() : facing.m_122428_();
    }

    private static boolean isUpper(BlockState state) {
        return (Integer)state.m_61143_((Property)LogicCabinetBlock.HEIGHT) != 0;
    }

    @Override
    public SelectionShapes getShape() {
        return this.selectionShapes.get();
    }

    private static SelectionShapes createSelectionShapes(Direction d, LogicCabinetBlockEntity bEntity, boolean upper, boolean mirror) {
        DirectionalShapeProvider baseShape;
        ArrayList<SelectionShapes> subshapes = new ArrayList<SelectionShapes>(1);
        DirectionalShapeProvider directionalShapeProvider = baseShape = upper ? LogicCabinetBlock.TOP_SHAPE : LogicCabinetBlock.BOTTOM_SHAPE;
        if (!upper) {
            subshapes.add(LogicCabinetBlockEntity.makeClockInteraction(bEntity));
        } else {
            subshapes.add(LogicCabinetBlockEntity.makeViewDesignInteraction(bEntity));
        }
        subshapes.add(LogicCabinetBlockEntity.makeBoardInteraction(bEntity, upper));
        return new ListShapes(baseShape.apply(d), MatrixUtils.inverseFacing(d, mirror), subshapes, bEntity::mainInteraction);
    }

    private InteractionResult mainInteraction(UseOnContext ctx) {
        if (ctx.m_43722_().m_204117_(IETags.hammers)) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                BlockPos otherPos = LogicCabinetBlockEntity.isUpper(this.m_58900_()) ? this.f_58858_.m_7495_() : this.f_58858_.m_7494_();
                for (BlockPos pos : List.of(this.f_58858_, otherPos)) {
                    BlockState state = this.f_58857_.m_8055_(pos);
                    if (!state.m_60713_(this.m_58900_().m_60734_())) continue;
                    BlockState newState = (BlockState)state.m_61124_((Property)LogicCabinetBlock.NOT_MIRRORED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)LogicCabinetBlock.NOT_MIRRORED) == false));
                    this.f_58857_.m_7731_(pos, newState, 3);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static SelectionShapes makeClockInteraction(LogicCabinetBlockEntity bEntity) {
        return new SingleShape(ShapeUtils.createPixelRelative(0.0, 6.0, 6.0, 5.0, 10.0, 10.0), ctx -> bEntity.clock.click((UseOnContext)ctx, () -> BEUtil.markDirtyAndSync(bEntity)));
    }

    private static SelectionShapes makeBoardInteraction(LogicCabinetBlockEntity bEntity, boolean upper) {
        int yOff = upper ? -16 : 0;
        VoxelShape fullShape = ShapeUtils.createPixelRelative(1.0, 11 + yOff, 1.0, 15.0, 31 + yOff, 15.0);
        return new SingleShape(fullShape, ctx -> {
            if (ctx.m_43723_() == null) {
                return InteractionResult.PASS;
            }
            if (!ctx.m_43725_().f_46443_) {
                Pair<Schematic, BusConnectedCircuit> oldSchematic = bEntity.circuit;
                Pair<Schematic, BusConnectedCircuit> schematic = PCBStackItem.getSchematicAndCircuit(ctx.m_43722_());
                if (schematic != null) {
                    bEntity.setSchematicAndComputeCircuit((Schematic)schematic.getFirst());
                    ctx.m_43722_().m_41774_(1);
                } else {
                    bEntity.setCircuit(null);
                    bEntity.markBusDirty.run();
                }
                if (oldSchematic != null) {
                    ItemUtil.giveOrDrop(ctx.m_43723_(), PCBStackItem.forSchematic((Schematic)oldSchematic.getFirst()));
                }
                BEUtil.markDirtyAndSync(bEntity);
            }
            return InteractionResult.SUCCESS;
        });
    }

    private static SelectionShapes makeViewDesignInteraction(LogicCabinetBlockEntity bEntity) {
        VoxelShape shape = ShapeUtils.createPixelRelative(15.0, 1.0, 4.0, 16.0, 11.0, 12.0);
        return new SingleShape(shape, ctx -> {
            Player player = ctx.m_43723_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (bEntity.circuit != null) {
                    NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, $, $2) -> CEContainers.LOGIC_DESIGN_VIEW.makeNew(id, bEntity), TextComponent.f_131282_));
                }
            }
            return InteractionResult.SUCCESS;
        });
    }

    @Override
    public Schematic getSchematic() {
        if (this.circuit != null) {
            return (Schematic)this.circuit.getFirst();
        }
        return new Schematic();
    }

    @Override
    public void setSchematicChanged() {
        if (this.circuit == null) {
            return;
        }
        HashMap leafcells = new HashMap();
        for (Circuit.PlacedLeafcell cell : ((BusConnectedCircuit)this.circuit.getSecond()).getCircuit().getCells()) {
            leafcells.put(cell.pos(), cell.cell());
        }
        for (PlacedSymbol symbol : ((Schematic)this.circuit.getFirst()).getSymbols()) {
            LeafcellInstance inCircuit;
            CellSymbol cellSymbol;
            SchematicSymbol symbolType = (SchematicSymbol)symbol.symbol().getType();
            if (!(symbolType instanceof CellSymbol) || !(cellSymbol = (CellSymbol)symbolType).canConfigureOnReadOnly() || (inCircuit = (LeafcellInstance)leafcells.get(symbol.position())) == null || inCircuit.getType() != cellSymbol.getCellType()) continue;
            inCircuit.applyConfigChange(symbol.symbol().getCurrentState());
        }
        this.m_6596_();
    }

    @Override
    public void getExtraDrops(Consumer<ItemStack> dropper) {
        RegistryObject<Item> clockItem;
        if (this.circuit != null) {
            dropper.accept(PCBStackItem.forSchematic((Schematic)this.circuit.getFirst()));
        }
        if ((clockItem = CEItems.CLOCK_GENERATORS.get(this.clock.getType().getRegistryName())) != null) {
            dropper.accept(((Item)clockItem.get()).m_7968_());
        }
    }

    @Override
    @Nullable
    public LogicCabinetBlockEntity computeMasterBE(BlockState stateHere) {
        if (LogicCabinetBlockEntity.isUpper(stateHere)) {
            BlockEntity below = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (below instanceof LogicCabinetBlockEntity) {
                return (LogicCabinetBlockEntity)below;
            }
            return null;
        }
        return this;
    }
}

