/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.logic;

import blusunrize.immersiveengineering.api.IETags;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.base.CEBlockEntity;
import malte0811.controlengineering.blockentity.base.IExtraDropBE;
import malte0811.controlengineering.blockentity.base.IHasMaster;
import malte0811.controlengineering.blockentity.logic.CircuitIngredientDrawer;
import malte0811.controlengineering.blockentity.logic.ISchematicBE;
import malte0811.controlengineering.blockentity.logic.LogicCabinetBlockEntity;
import malte0811.controlengineering.blocks.CEBlocks;
import malte0811.controlengineering.blocks.logic.LogicWorkbenchBlock;
import malte0811.controlengineering.blocks.shapes.ListShapes;
import malte0811.controlengineering.blocks.shapes.SelectionShapeOwner;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.blocks.shapes.SingleShape;
import malte0811.controlengineering.gui.CEContainers;
import malte0811.controlengineering.gui.misc.SyncContainer;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.items.IEItemRefs;
import malte0811.controlengineering.items.ISchematicItem;
import malte0811.controlengineering.items.PCBStackItem;
import malte0811.controlengineering.logic.circuit.BusConnectedCircuit;
import malte0811.controlengineering.logic.schematic.Schematic;
import malte0811.controlengineering.logic.schematic.SchematicCircuitConverter;
import malte0811.controlengineering.util.BEUtil;
import malte0811.controlengineering.util.CachedValue;
import malte0811.controlengineering.util.ItemUtil;
import malte0811.controlengineering.util.math.MatrixUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class LogicWorkbenchBlockEntity
extends CEBlockEntity
implements SelectionShapeOwner,
ISchematicBE,
MenuProvider,
IHasMaster<LogicWorkbenchBlockEntity>,
IExtraDropBE {
    public static final String TUBES_EMPTY_KEY = "controlengineering.gui.tubesEmpty";
    public static final String WIRES_EMPTY_KEY = "controlengineering.gui.wiresEmpty";
    public static final String MORE_BOARDS_THAN_MAX = "controlengineering.gui.moreThanMaxBoards";
    public static final String TOO_FEW_BOARDS_HELD = "controlengineering.gui.needMoreBoards";
    public static final String TOO_FEW_WIRES = "controlengineering.gui.needMoreWires";
    public static final String TOO_FEW_TUBES = "controlengineering.gui.needMoreTubes";
    private static final TagKey<Item> TUBES = IETags.circuitLogic;
    private static final TagKey<Item> WIRE = IETags.copperWire;
    @Nullable
    private Schematic schematic = null;
    private final CircuitIngredientDrawer tubeStorage = new CircuitIngredientDrawer(TUBES, "controlengineering.gui.tubesEmpty");
    private final CircuitIngredientDrawer wireStorage = new CircuitIngredientDrawer(WIRE, "controlengineering.gui.wiresEmpty");
    private final CachedValue<BlockState, SelectionShapes> shapes = new CachedValue<BlockState, SelectionShapes>(() -> ((LogicWorkbenchBlockEntity)this).m_58900_(), state -> {
        LogicWorkbenchBlock.Offset offset = (LogicWorkbenchBlock.Offset)((Object)((Object)state.m_61143_(LogicWorkbenchBlock.OFFSET)));
        Direction facing = (Direction)state.m_61143_(LogicWorkbenchBlock.FACING);
        VoxelShape baseShape = LogicWorkbenchBlock.SHAPE.apply(offset, facing);
        if (offset == LogicWorkbenchBlock.Offset.TOP_RIGHT) {
            Function<UseOnContext, InteractionResult> create = this.makeInteraction((BlockState)state, LogicWorkbenchBlockEntity::handleCreationClick);
            SelectionShapes wireDrawer = this.makeDrawerShape((BlockState)state, LogicWorkbenchBlock.WIRE_DRAWER_TOP_RIGHT, be -> be.wireStorage);
            return new ListShapes(baseShape, MatrixUtils.inverseFacing(facing), (List<? extends SelectionShapes>)ImmutableList.of((Object)new SingleShape(LogicWorkbenchBlock.BURNER, create), (Object)wireDrawer), $ -> InteractionResult.PASS);
        }
        if (offset == LogicWorkbenchBlock.Offset.TOP_LEFT) {
            SelectionShapes wireDrawer = this.makeDrawerShape((BlockState)state, LogicWorkbenchBlock.WIRE_DRAWER, be -> be.wireStorage);
            SelectionShapes tubeDrawer = this.makeDrawerShape((BlockState)state, LogicWorkbenchBlock.TUBE_DRAWER, be -> be.tubeStorage);
            return new ListShapes(baseShape, MatrixUtils.inverseFacing(facing), (List<? extends SelectionShapes>)ImmutableList.of((Object)tubeDrawer, (Object)wireDrawer), $ -> InteractionResult.PASS);
        }
        return new SingleShape(baseShape, this.makeInteraction((BlockState)state, LogicWorkbenchBlockEntity::handleMainClick));
    });

    public LogicWorkbenchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state2) {
        super(type, pos, state2);
    }

    private Function<UseOnContext, InteractionResult> makeInteraction(BlockState state, BiFunction<LogicWorkbenchBlockEntity, UseOnContext, InteractionResult> handler) {
        return ctx -> {
            LogicWorkbenchBlockEntity atOrigin = (LogicWorkbenchBlockEntity)this.getOrComputeMasterBE(state);
            if (atOrigin != null) {
                return (InteractionResult)handler.apply(atOrigin, (UseOnContext)ctx);
            }
            return InteractionResult.FAIL;
        };
    }

    @Override
    @Nullable
    public LogicWorkbenchBlockEntity computeMasterBE(BlockState state) {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockPos origin = ((LogicWorkbenchBlock)((Object)CEBlocks.LOGIC_WORKBENCH.get())).getMainBlock(state, this);
        BlockEntity atOrigin = this.f_58857_.m_7702_(origin);
        if (atOrigin instanceof LogicWorkbenchBlockEntity) {
            LogicWorkbenchBlockEntity originWB = (LogicWorkbenchBlockEntity)atOrigin;
            return originWB;
        }
        return null;
    }

    @Override
    public SelectionShapes getShape() {
        return this.shapes.get();
    }

    @Override
    protected void writeSyncedData(CompoundTag out) {
        this.writeCommonData(out);
        out.m_128379_("hasSchematic", this.schematic != null);
    }

    private void writeCommonData(CompoundTag out) {
        out.m_128365_("tubes", (Tag)this.tubeStorage.write());
        out.m_128365_("wires", (Tag)this.wireStorage.write());
    }

    @Override
    protected void readSyncedData(CompoundTag in) {
        this.readCommonData(in);
        boolean hadSchematic = this.schematic != null;
        boolean hasSchematic = in.m_128471_("hasSchematic");
        Schematic schematic = this.schematic = hasSchematic ? new Schematic() : null;
        if (hasSchematic != hadSchematic && this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void readCommonData(CompoundTag in) {
        this.tubeStorage.read(in.m_128469_("tubes"));
        this.wireStorage.read(in.m_128469_("wires"));
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        if (this.schematic != null) {
            compound.m_128365_("schematic", Schematic.CODEC.toNBT(this.schematic));
        }
        this.writeCommonData(compound);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        Tag schematicNBT = nbt.m_128423_("schematic");
        this.schematic = schematicNBT != null ? Schematic.CODEC.fromNBT(schematicNBT) : null;
        this.readCommonData(nbt);
    }

    private InteractionResult handleMainClick(UseOnContext ctx) {
        if (this.f_58857_ == null) {
            return InteractionResult.PASS;
        }
        if (this.schematic != null) {
            if (!this.f_58857_.f_46443_) {
                if (ctx.m_43723_() != null && ctx.m_43723_().m_6144_()) {
                    ItemUtil.giveOrDrop(ctx.m_43723_(), ISchematicItem.create(CEItems.SCHEMATIC, this.schematic));
                    this.schematic = null;
                    BEUtil.markDirtyAndSync(this);
                } else {
                    ((LogicWorkbenchBlock)((Object)CEBlocks.LOGIC_WORKBENCH.get())).openContainer(ctx.m_43723_(), this.m_58900_(), ctx.m_43725_(), this.f_58858_);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (ctx.m_43722_().m_150930_((Item)CEItems.SCHEMATIC.get())) {
            if (!this.f_58857_.f_46443_) {
                this.schematic = Objects.requireNonNullElseGet(ISchematicItem.getSchematic(ctx.m_43722_()), Schematic::new);
                ctx.m_43722_().m_41774_(1);
                BEUtil.markDirtyAndSync(this);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleCreationClick(UseOnContext ctx) {
        if (ctx.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        if (!ctx.m_43722_().m_150930_(IEItemRefs.CIRCUIT_BOARD.m_5456_()) || this.schematic == null) {
            return InteractionResult.PASS;
        }
        if (this.f_58857_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Optional<BusConnectedCircuit> circuit = SchematicCircuitConverter.toCircuit(this.schematic);
        if (circuit.isEmpty()) {
            return InteractionResult.FAIL;
        }
        int numTubes = this.schematic.getNumLogicTubes();
        int numBoards = LogicCabinetBlockEntity.getNumBoardsFor(numTubes);
        if (numBoards > 4) {
            ctx.m_43723_().m_5661_((Component)new TranslatableComponent(MORE_BOARDS_THAN_MAX, new Object[]{numBoards, 4}), true);
            return InteractionResult.FAIL;
        }
        if (numBoards > ctx.m_43722_().m_41613_()) {
            ctx.m_43723_().m_5661_((Component)new TranslatableComponent(TOO_FEW_BOARDS_HELD, new Object[]{numBoards}), true);
            return InteractionResult.FAIL;
        }
        int numWires = this.schematic.getWireLength();
        if (!this.f_58857_.f_46443_) {
            boolean enoughTubes = this.tubeStorage.canConsume(numTubes);
            boolean enoughWires = this.wireStorage.canConsume(numWires);
            if (enoughTubes && enoughWires) {
                this.tubeStorage.consume(numTubes);
                this.wireStorage.consume(numWires);
                ctx.m_43722_().m_41774_(numBoards);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                ItemUtil.giveOrDrop(ctx.m_43723_(), PCBStackItem.forSchematic(this.schematic));
                this.schematic = null;
                this.m_6596_();
            } else if (!enoughTubes) {
                ctx.m_43723_().m_5661_((Component)new TranslatableComponent(TOO_FEW_TUBES, new Object[]{numTubes}), true);
            } else {
                ctx.m_43723_().m_5661_((Component)new TranslatableComponent(TOO_FEW_WIRES, new Object[]{numWires}), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public CircuitIngredientDrawer getTubeStorage() {
        return this.tubeStorage;
    }

    public CircuitIngredientDrawer getWireStorage() {
        return this.wireStorage;
    }

    private SelectionShapes makeDrawerShape(BlockState state, VoxelShape shape, Function<LogicWorkbenchBlockEntity, CircuitIngredientDrawer> getDrawer) {
        Function<UseOnContext, InteractionResult> onClick = this.makeInteraction(state, (bEntity, ctx) -> {
            InteractionResult ret = ((CircuitIngredientDrawer)getDrawer.apply((LogicWorkbenchBlockEntity)bEntity)).interact((UseOnContext)ctx);
            bEntity.f_58857_.m_7260_(bEntity.f_58858_, bEntity.m_58900_(), bEntity.m_58900_(), 3);
            bEntity.m_6596_();
            return ret;
        });
        return new SingleShape(shape, onClick).setTextGetter(() -> {
            LogicWorkbenchBlockEntity main = (LogicWorkbenchBlockEntity)this.getOrComputeMasterBE(state);
            if (main == null) {
                return null;
            }
            CircuitIngredientDrawer drawer = (CircuitIngredientDrawer)getDrawer.apply(main);
            if (drawer.getStored().count() == 0) {
                return new TranslatableComponent(drawer.getEmptyKey());
            }
            return new TextComponent(drawer.getStored().count() + " x ").m_130946_(drawer.getStored().type().m_41786_().getString());
        });
    }

    @Override
    @Nullable
    public Schematic getSchematic() {
        return this.schematic;
    }

    @Override
    public void setSchematicChanged() {
        this.m_6596_();
    }

    public AvailableIngredients getCosts() {
        return new AvailableIngredients(this);
    }

    @Nonnull
    public Component m_5446_() {
        return TextComponent.f_131282_;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @Nonnull Inventory pInventory, @Nonnull Player pPlayer) {
        return CEContainers.LOGIC_DESIGN_EDIT.makeNew(pContainerId, this);
    }

    @Override
    public void getExtraDrops(Consumer<ItemStack> dropper) {
        this.tubeStorage.drop(dropper);
        this.wireStorage.drop(dropper);
        if (this.schematic != null) {
            dropper.accept(ISchematicItem.create(CEItems.SCHEMATIC, this.schematic));
        }
    }

    public static class AvailableIngredients {
        private Mutable<CircuitIngredientDrawer.BigItemStack> availableTubes;
        private Mutable<CircuitIngredientDrawer.BigItemStack> availableWires;

        public AvailableIngredients(LogicWorkbenchBlockEntity bEntity) {
            this.availableTubes = bEntity.getTubeStorage().getStoredRef();
            this.availableWires = bEntity.getWireStorage().getStoredRef();
        }

        public AvailableIngredients() {
            this.availableTubes = new MutableObject((Object)CircuitIngredientDrawer.BigItemStack.EMPTY);
            this.availableWires = new MutableObject((Object)CircuitIngredientDrawer.BigItemStack.EMPTY);
        }

        public CircuitIngredientDrawer.BigItemStack getAvailableTubes() {
            return (CircuitIngredientDrawer.BigItemStack)this.availableTubes.getValue();
        }

        public CircuitIngredientDrawer.BigItemStack getAvailableWires() {
            return (CircuitIngredientDrawer.BigItemStack)this.availableWires.getValue();
        }

        public Pair<Slot, DataSlot> makeTubeSlot(int id) {
            return AvailableIngredients.makeSlot(id, this.availableTubes);
        }

        public Pair<Slot, DataSlot> makeWireSlot(int id) {
            return AvailableIngredients.makeSlot(id, this.availableWires);
        }

        private static Pair<Slot, DataSlot> makeSlot(int id, final Mutable<CircuitIngredientDrawer.BigItemStack> stack) {
            return Pair.of((Object)SyncContainer.makeSyncSlot(id, s -> {
                int oldCount = ((CircuitIngredientDrawer.BigItemStack)stack.getValue()).count();
                stack.setValue((Object)new CircuitIngredientDrawer.BigItemStack((ItemStack)s, oldCount));
            }, () -> ((CircuitIngredientDrawer.BigItemStack)stack.getValue()).type()), (Object)new DataSlot(){

                public int m_6501_() {
                    return ((CircuitIngredientDrawer.BigItemStack)stack.getValue()).count();
                }

                public void m_6422_(int value) {
                    ItemStack oldType = ((CircuitIngredientDrawer.BigItemStack)stack.getValue()).type();
                    stack.setValue((Object)new CircuitIngredientDrawer.BigItemStack(oldType, value));
                }
            });
        }
    }
}

