/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.panels;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nullable;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.controlpanels.cnc.CNCInstructionParser;

public record CNCJob(ImmutableList<PlacedComponent> components, IntList tickPlacingComponent, IntList tapeProgressAfterComponent, int totalTicks, @Nullable String error) {
    public CNCJob {
        Preconditions.checkArgument((components.size() == tickPlacingComponent.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((components.size() == tapeProgressAfterComponent.size() ? 1 : 0) != 0);
    }

    public static CNCJob createFor(CNCInstructionParser.ParserResult parserData) {
        int timePerComponent = 60;
        IntArrayList tickEnds = new IntArrayList(parserData.components().size());
        for (int i = 0; i < parserData.componentEnds().size(); ++i) {
            tickEnds.add(60 * (i + 1));
        }
        return new CNCJob(parserData.components(), (IntList)tickEnds, parserData.componentEnds(), 60 * parserData.componentEnds().size() + 30, parserData.error());
    }

    public double getTapeProgressAtTime(double tick) {
        return this.interpolate(tick, arg_0 -> ((IntList)this.tapeProgressAfterComponent).getInt(arg_0));
    }

    public int getTotalComponents() {
        return this.components.size();
    }

    private double interpolate(double tick, Int2IntFunction getValue) {
        int lastTick;
        int lastValue;
        if (this.components.isEmpty()) {
            return 0.0;
        }
        int nextToPlace = this.getNumComponentsAt(tick);
        if (nextToPlace >= this.components.size()) {
            return getValue.applyAsInt(this.getTotalComponents() - 1);
        }
        int nextValue = getValue.applyAsInt(nextToPlace);
        int nextTick = this.tickPlacingComponent.getInt(nextToPlace);
        if (nextToPlace > 0) {
            lastValue = getValue.applyAsInt(nextToPlace - 1);
            lastTick = this.tickPlacingComponent.getInt(nextToPlace - 1);
        } else {
            lastValue = 0;
            lastTick = 0;
        }
        double deltaT = nextTick - lastTick;
        double deltaValue = nextValue - lastValue;
        return (double)lastValue + (tick - (double)lastTick) / deltaT * deltaValue;
    }

    private int getNumComponentsAt(double tick) {
        for (int end = 0; end < this.getTotalComponents(); ++end) {
            if (!((double)this.tickPlacingComponent.getInt(end) > tick)) continue;
            return end;
        }
        return this.getTotalComponents();
    }
}

