/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.panels;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.base.CEBlockEntity;
import malte0811.controlengineering.blockentity.base.IHasMaster;
import malte0811.controlengineering.blocks.panels.PanelBlock;
import malte0811.controlengineering.blocks.panels.PanelOrientation;
import malte0811.controlengineering.blocks.shapes.SelectionShapeOwner;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.blocks.shapes.SingleShape;
import malte0811.controlengineering.bus.BusEmitterCombiner;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.bus.IBusInterface;
import malte0811.controlengineering.bus.MarkDirtyHandler;
import malte0811.controlengineering.controlpanels.PanelComponentInstance;
import malte0811.controlengineering.controlpanels.PanelData;
import malte0811.controlengineering.controlpanels.PanelSelectionShapes;
import malte0811.controlengineering.controlpanels.PanelTransform;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.util.BEUtil;
import malte0811.controlengineering.util.Clearable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ControlPanelBlockEntity
extends CEBlockEntity
implements IBusInterface,
SelectionShapeOwner,
IHasMaster<ControlPanelBlockEntity> {
    private final MarkDirtyHandler markBusDirty = new MarkDirtyHandler();
    private List<PlacedComponent> components = new ArrayList<PlacedComponent>();
    private PanelTransform transform = new PanelTransform(0.25f, (float)Math.toDegrees(Math.atan(0.5)), PanelOrientation.DOWN_NORTH);
    private BusState inputState = BusState.EMPTY;
    private final BusEmitterCombiner<Integer> stateHandler = new BusEmitterCombiner<Integer>(i -> this.components.get((int)i).getComponent().getEmittedState(), i -> this.components.get((int)i).getComponent().updateTotalState(this.getTotalState()));

    public ControlPanelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resetStateHandler();
    }

    public void tickServer() {
        boolean updateClient = false;
        boolean updateBus = false;
        for (PlacedComponent component : this.components) {
            PanelComponentInstance.TickResult componentResult = component.tick();
            updateClient |= componentResult.updateClient();
            updateBus |= componentResult.updateBus();
        }
        if (updateBus) {
            this.updateBusState();
        }
        if (updateClient) {
            BEUtil.markDirtyAndSync(this);
        }
    }

    private void resetStateHandler() {
        this.stateHandler.clear();
        for (int i = 0; i < this.components.size(); ++i) {
            this.stateHandler.addEmitter(i);
        }
        this.updateBusState();
    }

    public void updateBusState() {
        boolean changed;
        BusState oldState = this.stateHandler.getTotalEmittedState();
        this.stateHandler.updateState(this.inputState);
        boolean bl = changed = !oldState.equals(this.stateHandler.getTotalEmittedState());
        if (changed) {
            this.markBusDirty.run();
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readComponentsAndTransform(nbt);
    }

    public void readComponentsAndTransform(CompoundTag nbt) {
        PanelData data = new PanelData(nbt, (PanelOrientation)((Object)this.m_58900_().m_61143_(PanelOrientation.PROPERTY)));
        this.transform = data.getTransform();
        this.components = data.getComponents();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.resetStateHandler();
        }
    }

    public void m_142339_(@Nonnull Level level) {
        super.m_142339_(level);
        if (!level.f_46443_) {
            this.resetStateHandler();
        }
    }

    @Override
    protected void writeSyncedData(CompoundTag out) {
        out.m_128391_(new PanelData(this).toNBT());
    }

    @Override
    protected void readSyncedData(CompoundTag in) {
        this.readComponentsAndTransform(in);
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSyncedData(compound);
    }

    public List<PlacedComponent> getComponents() {
        return this.components;
    }

    public PanelTransform getTransform() {
        return this.transform;
    }

    private BusState getTotalState() {
        return this.stateHandler.getTotalState();
    }

    @Override
    public void onBusUpdated(BusState totalState, BusState otherState) {
        if (!totalState.equals(this.inputState)) {
            this.inputState = totalState;
            this.updateBusState();
            BEUtil.markDirtyAndSync(this);
        }
    }

    @Override
    public BusState getEmittedState() {
        return this.stateHandler.getTotalEmittedState();
    }

    @Override
    public boolean canConnect(Direction fromSide) {
        return PanelBlock.isMaster(this.m_58900_());
    }

    @Override
    public void addMarkDirtyCallback(Clearable<Runnable> markDirty) {
        this.markBusDirty.addCallback(markDirty);
    }

    public void m_7651_() {
        super.m_7651_();
        this.markBusDirty.run();
    }

    @Override
    public SelectionShapes getShape() {
        BlockState state = this.m_58900_();
        if (!state.m_61138_((Property)PanelBlock.IS_BASE) || ((Boolean)state.m_61143_((Property)PanelBlock.IS_BASE)).booleanValue()) {
            return SingleShape.FULL_BLOCK;
        }
        ControlPanelBlockEntity base = PanelBlock.getBase((BlockGetter)this.f_58857_, state, this.f_58858_);
        if (base == null) {
            return SingleShape.FULL_BLOCK;
        }
        return new PanelSelectionShapes(base);
    }

    public PanelData getData() {
        return new PanelData(this);
    }

    @Override
    @Nullable
    public ControlPanelBlockEntity computeMasterBE(BlockState stateHere) {
        return PanelBlock.getBase((BlockGetter)this.f_58857_, stateHere, this.f_58858_);
    }
}

