/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.panels;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.MultiblockBEType;
import malte0811.controlengineering.blockentity.base.CEBlockEntity;
import malte0811.controlengineering.blockentity.base.IExtraDropBE;
import malte0811.controlengineering.blockentity.bus.ParallelPort;
import malte0811.controlengineering.blockentity.panels.CNCJob;
import malte0811.controlengineering.blockentity.tape.TapeDrive;
import malte0811.controlengineering.blocks.CEBlocks;
import malte0811.controlengineering.blocks.panels.PanelCNCBlock;
import malte0811.controlengineering.blocks.shapes.ListShapes;
import malte0811.controlengineering.blocks.shapes.SelectionShapeOwner;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.blocks.shapes.SingleShape;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.bus.IBusInterface;
import malte0811.controlengineering.bus.MarkDirtyHandler;
import malte0811.controlengineering.client.render.utils.PiecewiseAffinePath;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.controlpanels.cnc.CNCInstructionParser;
import malte0811.controlengineering.items.PanelTopItem;
import malte0811.controlengineering.items.PunchedTapeItem;
import malte0811.controlengineering.util.BEUtil;
import malte0811.controlengineering.util.BitUtils;
import malte0811.controlengineering.util.CachedValue;
import malte0811.controlengineering.util.CapabilityUtils;
import malte0811.controlengineering.util.Clearable;
import malte0811.controlengineering.util.DirectionUtils;
import malte0811.controlengineering.util.ItemUtil;
import malte0811.controlengineering.util.ShapeUtils;
import malte0811.controlengineering.util.math.MatrixUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.DeferredRegister;

public class PanelCNCBlockEntity
extends CEBlockEntity
implements SelectionShapeOwner,
IExtraDropBE,
IBusInterface {
    private static final int ENERGY_CONSUMPTION = 40;
    private State state = State.EMPTY;
    private final TapeDrive tape = new TapeDrive(() -> this.setState(this.state.addTape()), () -> this.setState(this.state.removeTape()), () -> this.state.canTakeTape());
    private final CachedValue<byte[], CNCJob> currentJob = new CachedValue<byte[], CNCJob>(this.tape::getNullableTapeContent, tape -> {
        if (tape != null) {
            return CNCJob.createFor(CNCInstructionParser.parse(this.f_58857_, BitUtils.toString(tape)));
        }
        return null;
    }, Arrays::equals, b -> b == null ? null : Arrays.copyOf(b, ((byte[])b).length));
    private int currentTicksInJob;
    private final List<PlacedComponent> currentPlacedComponents = new ArrayList<PlacedComponent>();
    private final List<CapabilityReference<IItemHandler>> neighborInventories = (List)Util.m_137469_(new ArrayList(), list -> {
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            list.add(CapabilityReference.forNeighbor((BlockEntity)this, (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Direction)d));
        }
    });
    private final EnergyStorage energy = new EnergyStorage(800);
    private final MarkDirtyHandler markBusDirty = new MarkDirtyHandler();
    private ParallelPort dataOutput = new ParallelPort();
    public CachedValue<CNCJob, PiecewiseAffinePath<Vec3>> headPath;
    private final CachedValue<Direction, SelectionShapes> bottomSelectionShapes = new CachedValue<Direction, SelectionShapes>(() -> (Direction)this.m_58900_().m_61143_(PanelCNCBlock.FACING), facing -> new ListShapes(Shapes.m_83144_(), MatrixUtils.inverseFacing(facing), (List<? extends SelectionShapes>)ImmutableList.of((Object)new SingleShape(ShapeUtils.createPixelRelative(1.0, 14.0, 1.0, 15.0, 16.0, 15.0), this::panelClick), (Object)new SingleShape(ShapeUtils.createPixelRelative(2.0, 4.0, 14.0, 14.0, 12.0, 16.0), this.tape::click)), ctx -> InteractionResult.PASS));
    private static final SelectionShapes topSelectionShapes = new SingleShape(PanelCNCBlock.UPPER_SHAPE, $ -> InteractionResult.PASS);
    private final CachedValue<BlockPos, AABB> renderBB = new CachedValue<BlockPos, AABB>(() -> this.f_58858_, pos -> new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 2)));

    public PanelCNCBlockEntity(BlockEntityType<?> type, BlockPos pos2, BlockState state) {
        super(type, pos2, state);
    }

    private InteractionResult panelClick(UseOnContext ctx) {
        ItemStack heldItem;
        if (this.f_58857_ == null) {
            return InteractionResult.PASS;
        }
        if (this.state.canTakePanel()) {
            if (!this.f_58857_.f_46443_ && ctx.m_43723_() != null) {
                ItemStack result = PanelTopItem.createWithComponents(this.currentPlacedComponents);
                ItemUtil.giveOrDrop(ctx.m_43723_(), result);
                this.currentPlacedComponents.clear();
                this.currentTicksInJob = 0;
                this.setState(this.state.removePanel());
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.state.hasPanel() && PanelTopItem.isEmptyPanelTop(heldItem = ctx.m_43722_())) {
            if (!this.f_58857_.f_46443_) {
                this.setState(this.state.addPanel());
                heldItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void clientTick() {
        if (this.state == State.RUNNING) {
            ++this.currentTicksInJob;
        }
    }

    public void tick() {
        if (this.dataOutput.tickTX()) {
            this.markBusDirty.run();
        }
        if (this.state.isInProcess()) {
            if (this.energy.extractEnergy(40, true) < 40) {
                this.setState(State.NO_ENERGY);
                return;
            }
            this.energy.extractEnergy(40, false);
            this.setState(State.RUNNING);
            ++this.currentTicksInJob;
            int nextComponent = this.currentPlacedComponents.size();
            CNCJob job = this.currentJob.get();
            if (nextComponent < job.getTotalComponents() && !this.f_58857_.f_46443_ && this.currentTicksInJob >= job.tickPlacingComponent().getInt(nextComponent)) {
                PlacedComponent componentToPlace = (PlacedComponent)job.components().get(nextComponent);
                List<IngredientWithSize> componentCost = ((PanelComponentType)componentToPlace.getComponent().getType()).getCost(this.f_58857_);
                if (!ItemUtil.tryConsumeItemsFrom(componentCost, this.neighborInventories)) {
                    this.dataOutput.queueStringWithParity("Unable to consume items for component number " + nextComponent);
                    this.setState(State.FAILED);
                } else {
                    this.currentPlacedComponents.add(componentToPlace);
                    BEUtil.markDirtyAndSync(this);
                }
            }
            if (this.currentTicksInJob >= job.totalTicks()) {
                if (job.error() != null) {
                    this.dataOutput.queueStringWithParity(job.error());
                    this.setState(State.FAILED);
                } else {
                    this.setState(State.DONE);
                }
            }
        }
    }

    @Override
    public SelectionShapes getShape() {
        if (((Boolean)this.m_58900_().m_61143_(PanelCNCBlock.UPPER)).booleanValue()) {
            return topSelectionShapes;
        }
        return this.bottomSelectionShapes.get();
    }

    @Nullable
    public CNCJob getCurrentJob() {
        return this.currentJob.get();
    }

    public int getTapeLength() {
        return this.tape.getTapeLength();
    }

    public int getCurrentTicksInJob() {
        return this.currentTicksInJob;
    }

    public List<PlacedComponent> getCurrentPlacedComponents() {
        return this.currentPlacedComponents;
    }

    public State getState() {
        return this.state;
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSyncedData(compound);
        compound.m_128365_("energy", this.energy.serializeNBT());
        compound.m_128365_("dataOutput", (Tag)this.dataOutput.toNBT());
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readSyncedData(nbt);
        this.energy.deserializeNBT(nbt.m_128423_("energy"));
        this.dataOutput = new ParallelPort(nbt.m_128469_("dataOutput"));
    }

    @Override
    protected void readSyncedData(CompoundTag compound) {
        this.tape.loadNBT(compound.m_128423_("tape"));
        this.currentTicksInJob = compound.m_128451_("currentTick");
        this.state = State.VALUES[compound.m_128451_("state")];
        this.currentPlacedComponents.clear();
        List<PlacedComponent> components = PlacedComponent.LIST_CODEC.fromNBT(compound.m_128423_("components"));
        if (components != null) {
            this.currentPlacedComponents.addAll(components);
        }
    }

    @Override
    protected void writeSyncedData(CompoundTag in) {
        in.m_128365_("tape", this.tape.toNBT());
        in.m_128405_("currentTick", this.currentTicksInJob);
        in.m_128405_("state", this.state.ordinal());
        in.m_128365_("components", PlacedComponent.LIST_CODEC.toNBT(this.currentPlacedComponents));
    }

    @Override
    public void getExtraDrops(Consumer<ItemStack> dropper) {
        if (this.tape.hasTape()) {
            dropper.accept(PunchedTapeItem.withBytes(this.tape.getTapeContent()));
        }
        if (this.state.hasPanel()) {
            dropper.accept(PanelTopItem.createWithComponents(this.currentPlacedComponents));
        }
    }

    public AABB getRenderBoundingBox() {
        return this.renderBB.get();
    }

    public static MultiblockBEType<PanelCNCBlockEntity, ?> register(DeferredRegister<BlockEntityType<?>> register) {
        return MultiblockBEType.makeType(register, "panel_cnc", PanelCNCBlockEntity::new, Dummy::new, CEBlocks.PANEL_CNC, PanelCNCBlock::isMaster);
    }

    private void setState(State state) {
        if (state != this.state) {
            this.state = state;
            BEUtil.markDirtyAndSync(this);
        }
    }

    @Override
    public void onBusUpdated(BusState totalState, BusState otherState) {
        this.dataOutput.onBusStateChange(otherState);
        this.m_6596_();
    }

    @Override
    public BusState getEmittedState() {
        return this.dataOutput.getOutputState();
    }

    @Override
    public boolean canConnect(Direction fromSide) {
        return fromSide == this.m_58900_().m_61143_(PanelCNCBlock.FACING);
    }

    @Override
    public void addMarkDirtyCallback(Clearable<Runnable> markDirty) {
        this.markBusDirty.addCallback(markDirty);
    }

    public void m_7651_() {
        super.m_7651_();
        this.markBusDirty.run();
    }

    public static enum State {
        EMPTY,
        HAS_TAPE,
        HAS_PANEL,
        RUNNING,
        NO_ENERGY,
        FAILED,
        DONE;

        public static final State[] VALUES;

        public boolean canTakePanel() {
            return this.hasPanel() && !this.isInProcess();
        }

        public boolean hasPanel() {
            return this == HAS_PANEL || this == RUNNING || this == NO_ENERGY || this == FAILED || this == DONE;
        }

        public boolean isInProcess() {
            return this == RUNNING || this == NO_ENERGY;
        }

        public State removePanel() {
            return switch (this) {
                case HAS_PANEL -> EMPTY;
                case FAILED, DONE -> HAS_TAPE;
                default -> throw new RuntimeException(this.name());
            };
        }

        public State addPanel() {
            return switch (this) {
                case EMPTY -> HAS_PANEL;
                case HAS_TAPE -> RUNNING;
                default -> throw new RuntimeException(this.name());
            };
        }

        public State addTape() {
            return switch (this) {
                case EMPTY -> HAS_TAPE;
                case HAS_PANEL -> RUNNING;
                default -> throw new RuntimeException(this.name());
            };
        }

        public boolean canTakeTape() {
            return this.hasTape() && !this.isInProcess();
        }

        public State removeTape() {
            return switch (this) {
                case HAS_TAPE -> EMPTY;
                case FAILED, DONE -> HAS_PANEL;
                default -> throw new RuntimeException(this.name());
            };
        }

        public boolean hasTape() {
            return this == HAS_TAPE || this == RUNNING || this == NO_ENERGY || this == FAILED || this == DONE;
        }

        static {
            VALUES = State.values();
        }
    }

    private static class Dummy
    extends CEBlockEntity {
        private LazyOptional<IEnergyStorage> energyRef = null;

        public Dummy(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityEnergy.ENERGY && CapabilityUtils.isNullOr(Direction.UP, side)) {
                if (this.energyRef == null) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
                    if (blockEntity instanceof PanelCNCBlockEntity) {
                        PanelCNCBlockEntity paneCNC = (PanelCNCBlockEntity)blockEntity;
                        this.energyRef = CapabilityUtils.constantOptional((Object)paneCNC.energy);
                    } else {
                        return LazyOptional.empty();
                    }
                }
                return this.energyRef.cast();
            }
            return super.getCapability(cap, side);
        }

        public void invalidateCaps() {
            super.invalidateCaps();
            if (this.energyRef != null) {
                this.energyRef.invalidate();
            }
        }
    }
}

