/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.panels;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import malte0811.controlengineering.blockentity.base.CEBlockEntity;
import malte0811.controlengineering.blockentity.tape.KeypunchBlockEntity;
import malte0811.controlengineering.blockentity.tape.KeypunchState;
import malte0811.controlengineering.blocks.CEBlocks;
import malte0811.controlengineering.blocks.panels.PanelDesignerBlock;
import malte0811.controlengineering.blocks.shapes.ListShapes;
import malte0811.controlengineering.blocks.shapes.SelectionShapeOwner;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.blocks.shapes.SingleShape;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.controlpanels.cnc.CNCInstructionGenerator;
import malte0811.controlengineering.gui.CEContainers;
import malte0811.controlengineering.util.BitUtils;
import malte0811.controlengineering.util.CachedValue;
import malte0811.controlengineering.util.math.MatrixUtils;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class PanelDesignerBlockEntity
extends CEBlockEntity
implements SelectionShapeOwner {
    private static final MyCodec<List<PlacedComponent>> COMPONENTS_CODEC = MyCodecs.list(PlacedComponent.CODEC);
    private final CachedValue<BlockState, SelectionShapes> shapes = new CachedValue<BlockState, SelectionShapes>(() -> ((PanelDesignerBlockEntity)this).m_58900_(), state -> {
        PanelDesignerBlock.Offset offset = (PanelDesignerBlock.Offset)((Object)((Object)state.m_61143_(PanelDesignerBlock.OFFSET)));
        Direction facing = (Direction)state.m_61143_(PanelDesignerBlock.FACING);
        VoxelShape baseShape = PanelDesignerBlock.SHAPE.apply(offset, facing);
        if (offset == PanelDesignerBlock.Offset.ORIGIN) {
            Function<UseOnContext, InteractionResult> openUI = this.makeInteraction((BlockState)state, PanelDesignerBlockEntity::openUI);
            return new ListShapes(baseShape, MatrixUtils.inverseFacing(facing), (List<? extends SelectionShapes>)ImmutableList.of((Object)new SingleShape(PanelDesignerBlock.TABLE_TOP, openUI)), $ -> InteractionResult.PASS);
        }
        if (offset == PanelDesignerBlock.Offset.BACK_TOP) {
            Function<UseOnContext, InteractionResult> writeTape = this.makeInteraction((BlockState)state, PanelDesignerBlockEntity::writeTape);
            Function<UseOnContext, InteractionResult> addTape = this.makeInteraction((BlockState)state, (t, ctx) -> t.state.removeOrAddClearTape(ctx.m_43723_(), ctx.m_43722_()));
            Function<UseOnContext, InteractionResult> takeTape = this.makeInteraction((BlockState)state, (t, ctx) -> t.state.removeWrittenTape(ctx.m_43723_()));
            return new ListShapes(baseShape, MatrixUtils.inverseFacing(facing), (List<? extends SelectionShapes>)ImmutableList.of((Object)new SingleShape(PanelDesignerBlock.BUTTON, writeTape), (Object)new SingleShape(KeypunchBlockEntity.INPUT_SHAPE, addTape), (Object)new SingleShape(KeypunchBlockEntity.OUTPUT_SHAPE, takeTape)), $ -> InteractionResult.PASS).setAllowTargetThrough(true);
        }
        return new SingleShape(baseShape, $ -> InteractionResult.PASS);
    });
    private final CachedValue<List<PlacedComponent>, Integer> requiredLength;
    private final List<PlacedComponent> components = new ArrayList<PlacedComponent>();
    private KeypunchState state = new KeypunchState(() -> ((PanelDesignerBlockEntity)this).m_6596_());

    public PanelDesignerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state2) {
        super(type, pos, state2);
        this.requiredLength = new CachedValue<List, Integer>(() -> this.components, l -> CNCInstructionGenerator.toInstructions(l).length(), l -> l.stream().map(c -> c.copy(false)).collect(Collectors.toList()));
    }

    private Function<UseOnContext, InteractionResult> makeInteraction(BlockState state, BiFunction<PanelDesignerBlockEntity, UseOnContext, InteractionResult> handler) {
        return ctx -> {
            BlockPos origin = ((PanelDesignerBlock)((Object)((Object)CEBlocks.PANEL_DESIGNER.get()))).getMainBlock(state, this);
            BlockEntity atOrigin = this.f_58857_.m_7702_(origin);
            if (atOrigin instanceof PanelDesignerBlockEntity) {
                PanelDesignerBlockEntity master = (PanelDesignerBlockEntity)atOrigin;
                return (InteractionResult)handler.apply(master, (UseOnContext)ctx);
            }
            return InteractionResult.FAIL;
        };
    }

    @Override
    public SelectionShapes getShape() {
        return this.shapes.get();
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.components.clear();
        this.components.addAll(COMPONENTS_CODEC.fromNBT(nbt.m_128423_("components"), List::of));
        this.state = new KeypunchState(() -> ((PanelDesignerBlockEntity)this).m_6596_(), nbt.m_128423_("state"));
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("components", COMPONENTS_CODEC.toNBT(this.components));
        compound.m_128365_("state", this.state.toNBT());
    }

    public List<PlacedComponent> getComponents() {
        return this.components;
    }

    private InteractionResult openUI(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(CEContainers.PANEL_DESIGN.argConstructor(this), TextComponent.f_131282_));
        }
        return InteractionResult.SUCCESS;
    }

    public int getLengthRequired() {
        return this.requiredLength.get();
    }

    private InteractionResult writeTape(UseOnContext ctx) {
        String instructions = CNCInstructionGenerator.toInstructions(this.components);
        byte[] bytes = BitUtils.toBytesWithParity(instructions);
        this.state.tryTypeAll((ByteList)new ByteArrayList(bytes, 0, bytes.length));
        this.m_6596_();
        return InteractionResult.SUCCESS;
    }

    public KeypunchState getKeypunch() {
        return this.state;
    }
}

