/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.tape;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.MultiblockBEType;
import malte0811.controlengineering.blockentity.base.CEBlockEntity;
import malte0811.controlengineering.blockentity.base.IExtraDropBE;
import malte0811.controlengineering.blockentity.base.IHasMaster;
import malte0811.controlengineering.blockentity.bus.ParallelPort;
import malte0811.controlengineering.blockentity.tape.KeypunchState;
import malte0811.controlengineering.blocks.CEBlocks;
import malte0811.controlengineering.blocks.shapes.ListShapes;
import malte0811.controlengineering.blocks.shapes.SelectionShapeOwner;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.blocks.shapes.SingleShape;
import malte0811.controlengineering.blocks.tape.KeypunchBlock;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.bus.IBusInterface;
import malte0811.controlengineering.bus.MarkDirtyHandler;
import malte0811.controlengineering.gui.tape.KeypunchMenu;
import malte0811.controlengineering.items.EmptyTapeItem;
import malte0811.controlengineering.items.PunchedTapeItem;
import malte0811.controlengineering.util.BEUtil;
import malte0811.controlengineering.util.BitUtils;
import malte0811.controlengineering.util.CachedValue;
import malte0811.controlengineering.util.Clearable;
import malte0811.controlengineering.util.ShapeUtils;
import malte0811.controlengineering.util.math.MatrixUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.DeferredRegister;

public class KeypunchBlockEntity
extends CEBlockEntity
implements IExtraDropBE,
IBusInterface,
SelectionShapeOwner {
    public static final VoxelShape SWITCH_SHAPE = ShapeUtils.createPixelRelative(6.0, 13.0, 0.0, 10.0, 16.0, 1.0);
    public static final VoxelShape INPUT_SHAPE = ShapeUtils.createPixelRelative(11.0, 3.0, 2.0, 15.0, 6.0, 4.0);
    public static final VoxelShape OUTPUT_SHAPE = ShapeUtils.createPixelRelative(2.0, 3.0, 1.0, 6.0, 7.0, 5.0);
    public static final String LOOPBACK_KEY = "controlengineering.gui.loopback";
    public static final String REMOTE_KEY = "controlengineering.gui.no_loopback";
    private final MarkDirtyHandler markBusDirty = new MarkDirtyHandler();
    private final Set<KeypunchMenu> onTapeChanged = new ReferenceOpenHashSet();
    private KeypunchState state = new KeypunchState(() -> ((KeypunchBlockEntity)this).m_6596_());
    private boolean loopback = true;
    private ParallelPort busInterface = new ParallelPort();
    private final CachedValue<Direction, SelectionShapes> selectionShapes = new CachedValue<Direction, SelectionShapes>(() -> (Direction)this.m_58900_().m_61143_(KeypunchBlock.FACING), f -> KeypunchBlockEntity.createSelectionShapes(f, this));

    public KeypunchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tickServer() {
        if (this.loopback) {
            return;
        }
        if (this.busInterface.tickTX()) {
            this.markBusDirty.run();
        }
        this.busInterface.tickRX().ifPresent(read -> {
            this.state.tryTypeChar((byte)read, false);
            for (KeypunchMenu c : this.onTapeChanged) {
                c.onTypedOnServer((byte)read);
            }
            this.m_6596_();
        });
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readSyncedData(nbt);
        this.state = new KeypunchState(() -> ((KeypunchBlockEntity)this).m_6596_(), nbt.m_128423_("state"));
        this.onTapeChanged.forEach(KeypunchMenu::resyncFullTape);
        this.busInterface = new ParallelPort(nbt.m_128469_("busInterface"));
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        this.writeSyncedData(compound);
        compound.m_128365_("state", this.state.toNBT());
        compound.m_128365_("busInterface", (Tag)this.busInterface.toNBT());
    }

    @Override
    protected void readSyncedData(CompoundTag in) {
        super.readSyncedData(in);
        boolean oldLoopback = this.loopback;
        this.loopback = in.m_128471_("loopback");
        if (this.loopback != oldLoopback && this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    protected void writeSyncedData(CompoundTag out) {
        super.writeSyncedData(out);
        out.m_128379_("loopback", this.loopback);
    }

    public KeypunchState getState() {
        return this.state;
    }

    @Override
    public void getExtraDrops(Consumer<ItemStack> dropper) {
        if (this.state.getAvailable() > 0) {
            dropper.accept(EmptyTapeItem.withLength(this.state.getAvailable()));
        }
        if (!this.state.getData().isEmpty() || this.state.getErased() > 0) {
            byte[] bytes = new byte[this.state.getData().size() + this.state.getErased()];
            System.arraycopy(this.state.getData().toByteArray(), 0, bytes, 0, this.state.getData().size());
            Arrays.fill(bytes, this.state.getData().size(), bytes.length, BitUtils.fixParity((byte)-1));
            dropper.accept(PunchedTapeItem.withBytes(bytes));
        }
    }

    public static MultiblockBEType<KeypunchBlockEntity, ?> register(DeferredRegister<BlockEntityType<?>> register) {
        return MultiblockBEType.makeType(register, "keypunch", KeypunchBlockEntity::new, Dummy::new, CEBlocks.KEYPUNCH, KeypunchBlock::isMaster);
    }

    @Override
    public void onBusUpdated(BusState totalState, BusState otherState) {
        if (!this.loopback) {
            this.busInterface.onBusStateChange(otherState);
            this.m_6596_();
        }
    }

    @Override
    public BusState getEmittedState() {
        if (this.loopback) {
            return BusState.EMPTY;
        }
        return this.busInterface.getOutputState();
    }

    @Override
    public boolean canConnect(Direction fromSide) {
        return fromSide == this.m_58900_().m_61143_(KeypunchBlock.FACING);
    }

    @Override
    public void addMarkDirtyCallback(Clearable<Runnable> markDirty) {
        this.markBusDirty.addCallback(markDirty);
    }

    public void m_7651_() {
        super.m_7651_();
        this.markBusDirty.run();
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public void queueForRemotePrint(byte toAdd) {
        Preconditions.checkState((!this.loopback ? 1 : 0) != 0);
        this.busInterface.queueChar(BitUtils.fixParity(toAdd));
    }

    public Set<KeypunchMenu> getOpenContainers() {
        return this.onTapeChanged;
    }

    @Override
    public SelectionShapes getShape() {
        return this.selectionShapes.get();
    }

    private static SelectionShapes createSelectionShapes(Direction d, KeypunchBlockEntity bEntity) {
        ArrayList<SelectionShapes> subshapes = new ArrayList<SelectionShapes>(1);
        subshapes.add(new SingleShape(SWITCH_SHAPE, $ -> {
            if (!bEntity.f_58857_.m_5776_()) {
                bEntity.loopback = !bEntity.loopback;
                BEUtil.markDirtyAndSync(bEntity);
            }
            return InteractionResult.SUCCESS;
        }).setTextGetter(() -> new TranslatableComponent(bEntity.isLoopback() ? LOOPBACK_KEY : REMOTE_KEY)));
        return new ListShapes(Shapes.m_83144_(), MatrixUtils.inverseFacing(d), subshapes, ctx -> {
            ((KeypunchBlock)((Object)((Object)CEBlocks.KEYPUNCH.get()))).openContainer(ctx.m_43723_(), bEntity.m_58900_(), ctx.m_43725_(), ctx.m_8083_());
            return InteractionResult.SUCCESS;
        });
    }

    private static class Dummy
    extends CEBlockEntity
    implements SelectionShapeOwner,
    IHasMaster<KeypunchBlockEntity> {
        private final CachedValue<Direction, SelectionShapes> selectionShapes = new CachedValue<Direction, SelectionShapes>(() -> (Direction)this.m_58900_().m_61143_(KeypunchBlock.FACING), f -> Dummy.createSelectionShapes(f, (KeypunchBlockEntity)this.getOrComputeMasterBE(this.m_58900_())));

        public Dummy(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public SelectionShapes getShape() {
            return this.selectionShapes.get();
        }

        private static SelectionShapes createSelectionShapes(Direction d, KeypunchBlockEntity bEntity) {
            ArrayList<SingleShape> subshapes = new ArrayList<SingleShape>(2);
            subshapes.add(new SingleShape(OUTPUT_SHAPE, ctx -> {
                InteractionResult result = bEntity.getState().removeWrittenTape(ctx.m_43723_());
                bEntity.onTapeChanged.forEach(KeypunchMenu::resyncFullTape);
                return result;
            }));
            subshapes.add(new SingleShape(INPUT_SHAPE, ctx -> bEntity.getState().removeOrAddClearTape(ctx.m_43723_(), ctx.m_43722_())));
            return new ListShapes(KeypunchBlock.SHAPE_PROVIDER.apply(d), MatrixUtils.inverseFacing(d), subshapes, ctx -> {
                ((KeypunchBlock)((Object)((Object)CEBlocks.KEYPUNCH.get()))).openContainer(ctx.m_43723_(), bEntity.m_58900_(), ctx.m_43725_(), ctx.m_8083_().m_7495_());
                return InteractionResult.SUCCESS;
            }).setAllowTargetThrough(true);
        }

        @Override
        @Nullable
        public KeypunchBlockEntity computeMasterBE(BlockState stateHere) {
            KeypunchBlockEntity keypunch;
            BlockEntity beBelow = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            return beBelow instanceof KeypunchBlockEntity ? (keypunch = (KeypunchBlockEntity)beBelow) : null;
        }
    }
}

