/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.tape;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.bytes.ByteLists;
import java.util.Arrays;
import malte0811.controlengineering.items.EmptyTapeItem;
import malte0811.controlengineering.items.PunchedTapeItem;
import malte0811.controlengineering.util.BitUtils;
import malte0811.controlengineering.util.ItemUtil;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodec3;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class KeypunchState {
    public static final int MAX_TAPE_LENGTH = 10000;
    private final Runnable markDirty;
    private final Data data;

    public KeypunchState(Runnable markDirty) {
        this(markDirty, new Data());
    }

    public KeypunchState(Runnable markDirty, Tag nbt) {
        this(markDirty, Data.CODEC.fromNBT(nbt, Data::new));
    }

    private KeypunchState(Runnable markDirty, Data data) {
        this.markDirty = markDirty;
        this.data = data;
    }

    public ByteList getData() {
        return this.data.data;
    }

    public int getAvailable() {
        return this.data.available;
    }

    public void setAvailable(int available) {
        this.data.available = available;
        this.markDirty.run();
    }

    public int getErased() {
        return this.data.numErased;
    }

    public void setErased(int numErased) {
        this.data.numErased = numErased;
        this.markDirty.run();
    }

    private boolean addAvailable(int length) {
        int newAvailable = length + this.getAvailable();
        if (this.getErased() + newAvailable > 10000) {
            return false;
        }
        this.setAvailable(this.getAvailable() + length);
        return true;
    }

    public InteractionResult removeWrittenTape(Player player) {
        ByteList written = this.getData();
        if (!written.isEmpty() && player != null) {
            ItemUtil.giveOrDrop(player, PunchedTapeItem.withBytes(written.toByteArray()));
            written.clear();
            this.markDirty.run();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult removeOrAddClearTape(Player player, ItemStack item) {
        int length = EmptyTapeItem.getLength(item);
        if (length > 0) {
            if (this.addAvailable(length)) {
                item.m_41774_(1);
            }
        } else if (this.getAvailable() > 0 && player != null) {
            ItemUtil.giveOrDrop(player, EmptyTapeItem.withLength(this.getAvailable()));
            this.setAvailable(0);
        }
        return InteractionResult.SUCCESS;
    }

    public int tryTypeAll(ByteList bytes) {
        int numLost = Math.min(bytes.size(), this.getErased());
        this.setErased(this.getErased() - numLost);
        byte[] erasedData = new byte[numLost];
        Arrays.fill(erasedData, BitUtils.fixParity((byte)-1));
        this.getData().addElements(this.getData().size(), erasedData);
        int numPrinted = Math.min(bytes.size() - numLost, this.getAvailable());
        this.setAvailable(this.getAvailable() - numPrinted);
        this.getData().addAll(bytes.subList(numLost, numLost + numPrinted));
        if (this.getData().size() > 10000) {
            this.getData().removeElements(9999, this.getData().size());
        }
        this.markDirty.run();
        return numLost + numPrinted;
    }

    public boolean tryTypeChar(byte typed, boolean fixParity) {
        return this.tryTypeAll(ByteLists.singleton((byte)(fixParity ? BitUtils.fixParity(typed) : typed))) >= 1;
    }

    public Tag toNBT() {
        return Data.CODEC.toNBT(this.data);
    }

    private static class Data {
        private static final MyCodec<Data> CODEC = new RecordCodec3<Data, ByteList, Integer, Integer>(new CodecField<Data, ByteList>("data", d -> d.data, MyCodecs.BYTE_LIST), new CodecField<Data, Integer>("available", d -> d.available, MyCodecs.INTEGER), new CodecField<Data, Integer>("numErased", d -> d.numErased, MyCodecs.INTEGER), Data::new);
        private final ByteList data;
        private int available;
        private int numErased;

        private Data(ByteList data, int available, int numErased) {
            this.data = data;
            this.available = available;
            this.numErased = numErased;
        }

        private Data() {
            this((ByteList)new ByteArrayList(), 0, 0);
        }
    }
}

