/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.tape;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.base.CEBlockEntity;
import malte0811.controlengineering.blockentity.logic.ClockSlot;
import malte0811.controlengineering.blockentity.tape.TapeDrive;
import malte0811.controlengineering.blocks.shapes.ListShapes;
import malte0811.controlengineering.blocks.shapes.SelectionShapeOwner;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import malte0811.controlengineering.blocks.shapes.SingleShape;
import malte0811.controlengineering.blocks.tape.SequencerBlock;
import malte0811.controlengineering.bus.BusLine;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.bus.IBusInterface;
import malte0811.controlengineering.bus.MarkDirtyHandler;
import malte0811.controlengineering.util.BEUtil;
import malte0811.controlengineering.util.BitUtils;
import malte0811.controlengineering.util.CachedValue;
import malte0811.controlengineering.util.CapabilityUtils;
import malte0811.controlengineering.util.Clearable;
import malte0811.controlengineering.util.RedstoneTapeUtils;
import malte0811.controlengineering.util.ShapeUtils;
import malte0811.controlengineering.util.energy.CEEnergyStorage;
import malte0811.controlengineering.util.math.MatrixUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class SequencerBlockEntity
extends CEBlockEntity
implements SelectionShapeOwner,
IBusInterface {
    private static final int BASE_CONSUMPTION = 16;
    private static final int CONSUMPTION_PER_STEP = 128;
    public static final String COMPACT_KEY = "controlengineering.gui.sequencer.compact";
    public static final String ANALOG_KEY = "controlengineering.gui.sequencer.analog";
    public static final String AUTORESET_KEY = "controlengineering.gui.sequencer.autoreset";
    public static final String MANUAL_RESET_KEY = "controlengineering.gui.sequencer.manualreset";
    private boolean compact = true;
    private boolean autoreset = true;
    private final TapeDrive tape = new TapeDrive(this::onTapeChange, this::onTapeChange, () -> true);
    private final ClockSlot clock = new ClockSlot();
    private final CEEnergyStorage energy = new CEEnergyStorage(2560, 256, 0);
    private int currentTapePosition = 0;
    private final MarkDirtyHandler markBusDirty = new MarkDirtyHandler();
    private final CachedValue<Direction, SelectionShapes> shapes = new CachedValue<Direction, SelectionShapes>(() -> (Direction)this.m_58900_().m_61143_(SequencerBlock.FACING), this::makeSelectionShapes);
    private final LazyOptional<IEnergyStorage> energyCap = CapabilityUtils.constantOptional((Object)this.energy);

    public SequencerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean isCompact() {
        return this.compact;
    }

    public boolean isAutoreset() {
        return this.autoreset;
    }

    public int getTapeLength() {
        return this.tape.getTapeLength();
    }

    public int getCurrentTapePosition() {
        return this.currentTapePosition;
    }

    public void tick() {
        boolean rsIn;
        if (!this.clock.isPresent() || !this.tape.hasTape() || this.currentTapePosition >= this.tape.getTapeLength() || this.f_58857_ == null) {
            return;
        }
        if (this.energy.extractOrTrue(16) || this.f_58857_.m_46467_() % 2L != 0L) {
            return;
        }
        Direction clockFace = ((Direction)this.m_58900_().m_61143_(SequencerBlock.FACING)).m_122428_();
        boolean bl = rsIn = this.f_58857_.m_46681_(this.f_58858_.m_142300_(clockFace), clockFace) > 0;
        if (this.clock.getClock().tick(rsIn) && !this.energy.extractOrTrue(128)) {
            int newPos;
            if ((newPos = ++this.currentTapePosition) < this.tape.getTapeLength()) {
                this.currentTapePosition = newPos;
            } else if (this.autoreset) {
                this.currentTapePosition = 0;
            }
            BEUtil.markDirtyAndSync(this);
        }
    }

    public void m_142466_(@Nonnull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.readSharedData(pTag);
        this.tape.loadNBT(pTag.m_128423_("tape"));
        this.clock.load(pTag.m_128423_("clock"));
        this.energy.readNBT(pTag.m_128423_("energy"));
    }

    protected void m_183515_(@Nonnull CompoundTag pTag) {
        super.m_183515_(pTag);
        this.writeSharedData(pTag);
        pTag.m_128365_("tape", this.tape.toNBT());
        pTag.m_128365_("clock", this.clock.toNBT());
        pTag.m_128365_("energy", this.energy.writeNBT());
    }

    @Override
    protected void readSyncedData(CompoundTag in) {
        super.readSyncedData(in);
        boolean oldCompact = this.compact;
        boolean oldAutoreset = this.autoreset;
        boolean hadClock = this.hasClock();
        this.readSharedData(in);
        this.clock.loadClientNBT(in.m_128423_("hasClock"));
        this.tape.loadClientNBT(in.m_128423_("syncTape"));
        if ((oldCompact != this.compact || oldAutoreset != this.autoreset || hadClock != this.hasClock()) && this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    protected void writeSyncedData(CompoundTag out) {
        super.writeSyncedData(out);
        this.writeSharedData(out);
        out.m_128365_("hasClock", this.clock.toClientNBT());
        out.m_128365_("syncTape", this.tape.toClientNBT());
    }

    private void readSharedData(CompoundTag in) {
        this.compact = in.m_128471_("compact");
        this.autoreset = in.m_128471_("autoreset");
        this.currentTapePosition = in.m_128451_("tapePosition");
    }

    private void writeSharedData(CompoundTag out) {
        out.m_128379_("compact", this.compact);
        out.m_128379_("autoreset", this.autoreset);
        out.m_128405_("tapePosition", this.currentTapePosition);
    }

    public boolean hasClock() {
        return this.clock.getType().isActiveClock();
    }

    private SelectionShapes makeSelectionShapes(Direction d) {
        ArrayList<SelectionShapes> shapes = new ArrayList<SelectionShapes>();
        shapes.add(new SingleShape(ShapeUtils.createPixelRelative(2.0, 4.0, 14.0, 14.0, 12.0, 16.0), this.tape::click));
        shapes.add(new SingleShape(ShapeUtils.createPixelRelative(4.0, 3.0, 0.0, 6.0, 6.0, 1.0), $ -> {
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.autoreset = !this.autoreset;
                BEUtil.markDirtyAndSync(this);
            }
            return InteractionResult.SUCCESS;
        }).setTextGetter(() -> new TranslatableComponent(this.autoreset ? AUTORESET_KEY : MANUAL_RESET_KEY)));
        shapes.add(new SingleShape(ShapeUtils.createPixelRelative(10.0, 3.0, 0.0, 12.0, 6.0, 1.0), $ -> {
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.compact = !this.compact;
                BEUtil.markDirtyAndSync(this);
            }
            return InteractionResult.SUCCESS;
        }).setTextGetter(() -> new TranslatableComponent(this.compact ? COMPACT_KEY : ANALOG_KEY)));
        shapes.add(new SingleShape(ShapeUtils.createPixelRelative(0.0, 6.0, 6.0, 5.0, 10.0, 10.0), ctx -> this.clock.click((UseOnContext)ctx, () -> BEUtil.markDirtyAndSync(this))));
        return new ListShapes(Shapes.m_83144_(), MatrixUtils.inverseFacing(d), shapes, $ -> InteractionResult.PASS);
    }

    @Override
    public SelectionShapes getShape() {
        return this.shapes.get();
    }

    private void onTapeChange() {
        this.currentTapePosition = 0;
        BEUtil.markDirtyAndSync(this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (side == Direction.UP || side == null)) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCap.invalidate();
    }

    @Override
    public void onBusUpdated(BusState totalState, BusState otherState) {
    }

    @Override
    public BusState getEmittedState() {
        if (!this.tape.hasTape() || this.currentTapePosition >= this.tape.getTapeContent().length) {
            return BusState.EMPTY;
        }
        byte toSend = this.tape.getTapeContent()[this.currentTapePosition];
        if (this.compact) {
            int[] line = new int[16];
            for (int i = 0; i < 8; ++i) {
                if (!BitUtils.getBit(toSend, i)) continue;
                line[i] = 255;
            }
            return BusState.EMPTY.withLine(0, new BusLine(line));
        }
        int color = RedstoneTapeUtils.getColorId(toSend);
        int strength = RedstoneTapeUtils.getStrength(toSend);
        return BusState.EMPTY.with(0, color, strength * 17);
    }

    @Override
    public boolean canConnect(Direction fromSide) {
        return fromSide == ((Direction)this.m_58900_().m_61143_(SequencerBlock.FACING)).m_122427_();
    }

    @Override
    public void addMarkDirtyCallback(Clearable<Runnable> markDirty) {
        this.markBusDirty.addCallback(markDirty);
    }

    public void m_7651_() {
        super.m_7651_();
        this.markBusDirty.run();
    }
}

