/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blockentity.tape;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import malte0811.controlengineering.items.CEItems;
import malte0811.controlengineering.items.PunchedTapeItem;
import malte0811.controlengineering.util.ItemUtil;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class TapeDrive {
    private final Runnable onAdd;
    private final Runnable onRemove;
    private final BooleanSupplier canTake;
    @Nullable
    private byte[] insertedTape = null;

    public TapeDrive(Runnable onAdd, Runnable onRemove, BooleanSupplier canTake) {
        this.onAdd = onAdd;
        this.onRemove = onRemove;
        this.canTake = canTake;
    }

    public InteractionResult click(UseOnContext ctx) {
        ItemStack held = ctx.m_43722_();
        Level level = ctx.m_43725_();
        if (this.insertedTape == null) {
            if (CEItems.PUNCHED_TAPE.get() == held.m_41720_()) {
                if (!level.f_46443_) {
                    this.insertedTape = PunchedTapeItem.getBytes(held);
                    this.onAdd.run();
                    held.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (this.canTake.getAsBoolean()) {
            if (!level.f_46443_) {
                ItemStack result = PunchedTapeItem.withBytes(this.insertedTape);
                this.insertedTape = null;
                this.onRemove.run();
                ItemUtil.giveOrDrop(ctx.m_43723_(), result);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public byte[] getTapeContent() {
        return Objects.requireNonNull(this.insertedTape);
    }

    @Nullable
    public byte[] getNullableTapeContent() {
        return this.insertedTape;
    }

    public boolean hasTape() {
        return this.insertedTape != null;
    }

    public int getTapeLength() {
        return this.hasTape() ? this.getTapeContent().length : 0;
    }

    public Tag toNBT() {
        if (this.hasTape()) {
            return new ByteArrayTag(this.getTapeContent());
        }
        return new ByteArrayTag(new byte[0]);
    }

    public void loadNBT(Tag data) {
        ByteArrayTag bat;
        this.insertedTape = (byte[])(data instanceof ByteArrayTag && (bat = (ByteArrayTag)data).m_128227_().length > 0 ? bat.m_128227_() : null);
    }

    public void loadClientNBT(Tag syncTape) {
        NumericTag numeric;
        this.insertedTape = (byte[])(syncTape instanceof NumericTag && (numeric = (NumericTag)syncTape).m_7047_() > 0 ? new byte[numeric.m_7047_()] : null);
    }

    public Tag toClientNBT() {
        return IntTag.m_128679_((int)this.getTapeLength());
    }
}

