/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks;

import com.mojang.datafixers.util.Pair;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.base.IHasMaster;
import malte0811.controlengineering.blockentity.base.INeighborChangeListener;
import malte0811.controlengineering.blocks.placement.PlacementBehavior;
import malte0811.controlengineering.blocks.shapes.FromBlockFunction;
import malte0811.controlengineering.blocks.shapes.SelectionShapeOwner;
import malte0811.controlengineering.gui.CustomDataContainerProvider;
import malte0811.controlengineering.util.RaytraceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;

public abstract class CEBlock<PlacementData>
extends Block
implements EntityBlock {
    public final PlacementBehavior<PlacementData> placementBehavior;
    private final FromBlockFunction<VoxelShape> getShape;
    @Nullable
    private final BiFunction<BlockPos, BlockState, ? extends BlockEntity> beType;

    public <BE extends BlockEntity> CEBlock(BlockBehaviour.Properties properties, PlacementBehavior<PlacementData> placement, FromBlockFunction<VoxelShape> getShape, @Nullable RegistryObject<BlockEntityType<BE>> beType) {
        this(properties, placement, getShape, (BlockPos bp, BlockState bs) -> ((BlockEntityType)beType.get()).m_155264_(bp, bs));
    }

    public CEBlock(BlockBehaviour.Properties properties, PlacementBehavior<PlacementData> placement, FromBlockFunction<VoxelShape> getShape, @Nullable BiFunction<BlockPos, BlockState, ? extends BlockEntity> beType) {
        super(properties);
        this.placementBehavior = placement;
        this.getShape = getShape;
        this.beType = beType;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            return;
        }
        BlockEntity bEntity = worldIn.m_7702_(pos);
        if (bEntity instanceof IHasMaster) {
            IHasMaster hasMaster = (IHasMaster)bEntity;
            hasMaster.setCachedMaster((BlockEntity)hasMaster.computeMasterBE(state));
        }
        Pair<PlacementData, BlockPos> dataAndOffset = this.placementBehavior.getPlacementDataAndOffset(state, bEntity);
        super.m_6810_(state, worldIn, pos, newState, isMoving);
        for (BlockPos offset : this.placementBehavior.getPlacementOffsets(dataAndOffset.getFirst())) {
            BlockEntity offsetBE;
            BlockPos absolute;
            BlockState offsetState;
            BlockPos relative = offset.m_141950_((Vec3i)dataAndOffset.getSecond());
            if (BlockPos.f_121853_.equals((Object)relative) || !this.placementBehavior.isValidAtOffset(offset, offsetState = worldIn.m_8055_(absolute = pos.m_141952_((Vec3i)relative)), offsetBE = worldIn.m_7702_(absolute), dataAndOffset.getFirst())) continue;
            worldIn.m_46597_(absolute, Blocks.f_50016_.m_49966_());
        }
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getShape.apply(state, worldIn, pos);
    }

    @Nonnull
    public VoxelShape m_5909_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        SelectionShapeOwner shapeOwner;
        VoxelShape selShape;
        BlockEntity bEntity = reader.m_7702_(pos);
        if (bEntity instanceof SelectionShapeOwner && (selShape = (shapeOwner = (SelectionShapeOwner)bEntity).getShape().mainShape()) != null) {
            return selShape;
        }
        return super.m_5909_(state, reader, pos, context);
    }

    @Nonnull
    public VoxelShape m_7952_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return state.m_60816_(worldIn, pos);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof SelectionShapeOwner) {
            SelectionShapeOwner shapeOwner = (SelectionShapeOwner)blockEntity;
            return shapeOwner.getShape().onUse(new UseOnContext(player, handIn, hit), RaytraceUtils.create(player, 0.0f, Vec3.m_82528_((Vec3i)pos)));
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void openContainer(Player player, BlockState state, Level worldIn, BlockPos pos) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuProvider container = state.m_60750_(worldIn, pos);
            if (container instanceof CustomDataContainerProvider) {
                CustomDataContainerProvider customProvider = (CustomDataContainerProvider)container;
                customProvider.open(serverPlayer);
            } else {
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)container, (BlockPos)pos);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        if (this.beType != null) {
            return this.beType.apply(pPos, pState);
        }
        return null;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof INeighborChangeListener) {
            INeighborChangeListener listener = (INeighborChangeListener)blockEntity;
            listener.onNeighborChanged(neighbor);
        }
    }

    public BlockPos getMainBlock(BlockState state, BlockEntity bEntity) {
        Pair<PlacementData, BlockPos> data = this.placementBehavior.getPlacementDataAndOffset(state, bEntity);
        return bEntity.m_58899_().m_141950_((Vec3i)data.getSecond());
    }

    protected static BlockBehaviour.Properties defaultProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 15.0f).m_60918_(SoundType.f_56743_);
    }

    protected static BlockBehaviour.Properties defaultPropertiesNotSolid() {
        return CEBlock.defaultProperties().m_60955_().m_60924_(($1, $2, $3) -> false).m_60988_();
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> actual, RegistryObject<BlockEntityType<E>> expected, Consumer<E> ticker) {
        return expected.get() == actual ? ($, $2, $3, bEntity) -> ticker.accept(bEntity) : null;
    }
}

