/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.logic;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.CEBlockEntities;
import malte0811.controlengineering.blockentity.logic.LogicWorkbenchBlockEntity;
import malte0811.controlengineering.blocks.CEBlock;
import malte0811.controlengineering.blocks.placement.HorizontalStructurePlacement;
import malte0811.controlengineering.blocks.shapes.FromBlockFunction;
import malte0811.controlengineering.blocks.shapes.HorizontalWithExtraShape;
import malte0811.controlengineering.util.ShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LogicWorkbenchBlock
extends CEBlock<Direction> {
    public static final Property<Offset> OFFSET = EnumProperty.m_61587_((String)"offset", Offset.class);
    public static final Property<Direction> FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape TABLE_TOP = ShapeUtils.createPixelRelative(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape LEG_LEFT_FRONT = ShapeUtils.createPixelRelative(1.0, 0.0, 12.0, 4.0, 16.0, 15.0);
    private static final VoxelShape LEG_LEFT_BACK = ShapeUtils.createPixelRelative(1.0, 0.0, 1.0, 4.0, 16.0, 4.0);
    private static final VoxelShape LEG_RIGHT_FRONT = ShapeUtils.createPixelRelative(12.0, 0.0, 12.0, 15.0, 16.0, 15.0);
    private static final VoxelShape LEG_RIGHT_BACK = ShapeUtils.createPixelRelative(12.0, 0.0, 1.0, 15.0, 16.0, 4.0);
    private static final VoxelShape DRAWER_LOW = ShapeUtils.createPixelRelative(1.0, 7.0, 1.0, 15.0, 13.0, 15.0);
    public static final VoxelShape BURNER = Shapes.m_83110_((VoxelShape)ShapeUtils.createPixelRelative(11.0, 0.0, 3.0, 13.0, 6.0, 5.0), (VoxelShape)ShapeUtils.createPixelRelative(9.0, 4.5, 3.5, 11.0, 5.5, 4.5));
    public static final VoxelShape TUBE_DRAWER = ShapeUtils.createPixelRelative(2.0, 0.0, 2.0, 10.0, 8.0, 8.0);
    public static final VoxelShape WIRE_DRAWER = ShapeUtils.createPixelRelative(12.0, 0.0, 2.0, 20.0, 8.0, 8.0);
    private static final VoxelShape DRAWERS_TOP = Shapes.m_83110_((VoxelShape)TUBE_DRAWER, (VoxelShape)WIRE_DRAWER);
    public static final VoxelShape WIRE_DRAWER_TOP_RIGHT = WIRE_DRAWER.m_83216_(-1.0, 0.0, 0.0);
    public static final HorizontalWithExtraShape<Offset> SHAPE = new HorizontalWithExtraShape<Offset>(FromBlockFunction.getProperty(OFFSET), FromBlockFunction.getProperty(FACING), (Map<Offset, VoxelShape>)ImmutableMap.builder().put((Object)Offset.ORIGIN, (Object)Shapes.m_83124_((VoxelShape)TABLE_TOP, (VoxelShape[])new VoxelShape[]{LEG_LEFT_FRONT, LEG_LEFT_BACK, LEG_RIGHT_FRONT, LEG_RIGHT_BACK, DRAWER_LOW})).put((Object)Offset.BACK_LEFT, (Object)Shapes.m_83110_((VoxelShape)TABLE_TOP, (VoxelShape)LEG_LEFT_BACK)).put((Object)Offset.FRONT_RIGHT, (Object)Shapes.m_83110_((VoxelShape)TABLE_TOP, (VoxelShape)LEG_RIGHT_FRONT)).put((Object)Offset.BACK_RIGHT, (Object)Shapes.m_83110_((VoxelShape)TABLE_TOP, (VoxelShape)LEG_RIGHT_BACK)).put((Object)Offset.TOP_LEFT, (Object)DRAWERS_TOP).put((Object)Offset.TOP_RIGHT, (Object)Shapes.m_83110_((VoxelShape)BURNER, (VoxelShape)WIRE_DRAWER_TOP_RIGHT)).build());

    public LogicWorkbenchBlock() {
        super(LogicWorkbenchBlock.defaultPropertiesNotSolid(), new HorizontalStructurePlacement<Offset>(FACING, OFFSET, Offset::getOffset), SHAPE, CEBlockEntities.LOGIC_WORKBENCH);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OFFSET, FACING});
    }

    @Nullable
    public MenuProvider m_7246_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof LogicWorkbenchBlockEntity) {
            LogicWorkbenchBlockEntity workbenchHere = (LogicWorkbenchBlockEntity)blockEntity;
            return (MenuProvider)workbenchHere.getOrComputeMasterBE(state);
        }
        return null;
    }

    public static boolean isMaster(BlockState state) {
        return state.m_61143_(OFFSET) == Offset.ORIGIN;
    }

    public static enum Offset implements StringRepresentable
    {
        ORIGIN(0, 0),
        FRONT_RIGHT(1, 0),
        BACK_LEFT(0, -1),
        BACK_RIGHT(1, -1),
        TOP_LEFT(0, 1, -1),
        TOP_RIGHT(1, 1, -1);

        private final BlockPos offset;

        private Offset(int xOff, int zOff) {
            this(xOff, 0, zOff);
        }

        private Offset(int xOff, int yOff, int zOff) {
            this.offset = new BlockPos(xOff, yOff, zOff);
        }

        public BlockPos getOffset() {
            return this.offset;
        }

        @Nonnull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

