/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.panels;

import java.util.ArrayList;
import malte0811.controlengineering.blockentity.panels.ControlPanelBlockEntity;
import malte0811.controlengineering.blocks.panels.PanelBlock;
import malte0811.controlengineering.blocks.panels.PanelOrientation;
import malte0811.controlengineering.blocks.shapes.CachedShape;
import malte0811.controlengineering.blocks.shapes.FromBlockFunction;
import malte0811.controlengineering.controlpanels.PanelTransform;
import malte0811.controlengineering.util.ShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CachedPanelShape
extends CachedShape<PanelTransform> {
    @Override
    protected VoxelShape compute(PanelTransform transform) {
        return CachedPanelShape.getPanelShape(transform);
    }

    public static VoxelShape getPanelShape(PanelTransform transform) {
        ArrayList<AABB> parts = new ArrayList<AABB>();
        double frontHeight = Math.max(transform.getCenterHeight(), (double)transform.getFrontHeight());
        double backHeight = Math.max(transform.getCenterHeight(), (double)transform.getBackHeight());
        parts.add(new AABB(0.0, 0.0, 0.0, 0.5, frontHeight, 1.0));
        parts.add(new AABB(0.5, 0.0, 0.0, 1.0, backHeight, 1.0));
        return ShapeUtils.or(parts.stream().map(ShapeUtils.transformFunc(transform.getPanelBottomToWorld())));
    }

    @Override
    protected PanelTransform getKey(BlockState state, BlockGetter world, BlockPos pos) {
        ControlPanelBlockEntity base = PanelBlock.getBase(world, state, pos);
        if (base != null) {
            return base.getTransform();
        }
        return new PanelTransform(0.5f, 0.0f, PanelOrientation.DOWN_NORTH);
    }

    public static FromBlockFunction<VoxelShape> create() {
        return FromBlockFunction.either(FromBlockFunction.getProperty(PanelBlock.IS_BASE), new CachedPanelShape(), FromBlockFunction.constant(Shapes.m_83144_()));
    }
}

