/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.panels;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public enum PanelOrientation implements StringRepresentable
{
    DOWN_NORTH(Direction.DOWN, Direction.NORTH),
    DOWN_EAST(Direction.DOWN, Direction.EAST),
    DOWN_SOUTH(Direction.DOWN, Direction.SOUTH),
    DOWN_WEST(Direction.DOWN, Direction.WEST),
    UP_NORTH(Direction.UP, Direction.NORTH),
    UP_EAST(Direction.UP, Direction.EAST),
    UP_SOUTH(Direction.UP, Direction.SOUTH),
    UP_WEST(Direction.UP, Direction.WEST),
    NORTH(Direction.NORTH, Direction.SOUTH),
    EAST(Direction.EAST, PanelOrientation.NORTH.front),
    SOUTH(Direction.SOUTH, PanelOrientation.NORTH.front),
    WEST(Direction.WEST, PanelOrientation.NORTH.front);

    public static final Property<PanelOrientation> PROPERTY;
    public static final Direction HORIZONTAL_FRONT;
    public final Direction top;
    public final Direction front;

    private PanelOrientation(Direction top, Direction front) {
        this.top = top;
        this.front = front;
    }

    public String toString() {
        return this.m_7912_();
    }

    @Nonnull
    public String m_7912_() {
        return (this.top + "_" + this.front).toLowerCase(Locale.US);
    }

    public static PanelOrientation get(Direction top, Direction front) {
        for (PanelOrientation po : PanelOrientation.values()) {
            if (po.top != top || po.front != front) continue;
            return po;
        }
        throw new RuntimeException("No panel orientation for front=" + front + ", top=" + top);
    }

    static {
        PROPERTY = EnumProperty.m_61587_((String)"orientation", PanelOrientation.class);
        HORIZONTAL_FRONT = PanelOrientation.NORTH.front;
    }
}

