/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.placement;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import malte0811.controlengineering.blocks.placement.PlacementBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class HorizontalStructurePlacement<T extends Comparable<T>>
implements PlacementBehavior<Direction> {
    private final Property<Direction> facingProperty;
    private final Property<T> offsetProperty;
    private final BiMap<T, BlockPos> getBaseOffset;

    public HorizontalStructurePlacement(Property<Direction> facingProperty, Property<T> offsetProperty, Function<T, BlockPos> getBaseOffset) {
        this.facingProperty = facingProperty;
        this.offsetProperty = offsetProperty;
        this.getBaseOffset = HashBiMap.create();
        for (Comparable t : offsetProperty.m_6908_()) {
            this.getBaseOffset.put((Object)t, (Object)getBaseOffset.apply(t));
        }
    }

    public static HorizontalStructurePlacement<Integer> column(Property<Direction> facing, Property<Integer> columnHeight) {
        return new HorizontalStructurePlacement<Integer>(facing, columnHeight, arg_0 -> ((BlockPos)BlockPos.f_121853_).m_6630_(arg_0));
    }

    public static HorizontalStructurePlacement<Boolean> column2(Property<Direction> facing, Property<Boolean> upper) {
        return new HorizontalStructurePlacement<Boolean>(facing, upper, b -> b != false ? BlockPos.f_121853_.m_7494_() : BlockPos.f_121853_);
    }

    @Override
    public Direction getPlacementData(BlockPlaceContext ctx) {
        return ctx.m_8125_();
    }

    @Override
    public Pair<Direction, BlockPos> getPlacementDataAndOffset(BlockState state, BlockEntity be) {
        Comparable offset = state.m_61143_(this.offsetProperty);
        Direction facing = (Direction)state.m_61143_(this.facingProperty);
        return Pair.of((Object)facing, (Object)this.getPhysicalOffset(facing, offset));
    }

    @Override
    public Collection<BlockPos> getPlacementOffsets(Direction data) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (BlockPos p : this.getBaseOffset.values()) {
            list.add(HorizontalStructurePlacement.getPhysicalOffset(data, p));
        }
        return list;
    }

    @Override
    public BlockState getStateForOffset(Block owner, BlockPos physicalOffset, Direction data) {
        return (BlockState)((BlockState)owner.m_49966_().m_61124_(this.facingProperty, (Comparable)data)).m_61124_(this.offsetProperty, (Comparable)this.getBaseOffset.inverse().get((Object)HorizontalStructurePlacement.getLogicalOffset(data, physicalOffset)));
    }

    @Override
    public boolean isValidAtOffset(BlockPos physicalOffset, BlockState state, BlockEntity be, Direction data) {
        if (!state.m_61138_(this.facingProperty) || !state.m_61138_(this.offsetProperty) || state.m_61143_(this.facingProperty) != data) {
            return false;
        }
        Comparable logical = state.m_61143_(this.offsetProperty);
        BlockPos physical = this.getPhysicalOffset(data, logical);
        return physicalOffset.equals((Object)physical);
    }

    private BlockPos getPhysicalOffset(Direction facing, T logicalOffset) {
        return HorizontalStructurePlacement.getPhysicalOffset(facing, (BlockPos)this.getBaseOffset.get(logicalOffset));
    }

    private static BlockPos getPhysicalOffset(Direction facing, BlockPos logicalOffset) {
        Rotation rot = DirectionUtils.getRotationBetweenFacings((Direction)Direction.NORTH, (Direction)facing);
        StructurePlaceSettings placeSet = new StructurePlaceSettings().m_74379_(rot);
        return StructureTemplate.m_74563_((StructurePlaceSettings)placeSet, (BlockPos)logicalOffset);
    }

    private static BlockPos getLogicalOffset(Direction facing, BlockPos physicalOffset) {
        Rotation rot = DirectionUtils.getRotationBetweenFacings((Direction)facing, (Direction)Direction.NORTH);
        StructurePlaceSettings placeSet = new StructurePlaceSettings().m_74379_(rot);
        return StructureTemplate.m_74563_((StructurePlaceSettings)placeSet, (BlockPos)physicalOffset);
    }
}

