/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.shapes;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.function.Function;
import malte0811.controlengineering.blocks.shapes.FromBlockFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class CachedShape<Key>
implements FromBlockFunction<VoxelShape>,
Function<Key, VoxelShape> {
    private final Cache<Key, VoxelShape> shapeCache = CacheBuilder.newBuilder().maximumSize(100L).build();

    @Override
    public VoxelShape apply(BlockState state, BlockGetter world, BlockPos pos) {
        Key k = this.getKey(state, world, pos);
        return this.apply(k);
    }

    @Override
    public VoxelShape apply(Key k) {
        VoxelShape present = (VoxelShape)this.shapeCache.getIfPresent(k);
        if (present == null) {
            present = this.compute(k);
            this.shapeCache.put(k, (Object)present);
        }
        return present;
    }

    protected abstract VoxelShape compute(Key var1);

    protected abstract Key getKey(BlockState var1, BlockGetter var2, BlockPos var3);
}

