/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.shapes;

import com.mojang.math.Matrix4f;
import java.util.List;
import malte0811.controlengineering.blocks.shapes.CachedShape;
import malte0811.controlengineering.blocks.shapes.FromBlockFunction;
import malte0811.controlengineering.util.math.MatrixUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DirectionalShapeProvider
extends CachedShape<Direction> {
    private final FromBlockFunction<Direction> getKey;
    private final VoxelShape baseShape;

    public DirectionalShapeProvider(FromBlockFunction<Direction> getKey, VoxelShape baseShape) {
        this.getKey = getKey;
        this.baseShape = baseShape;
    }

    @Override
    protected VoxelShape compute(Direction k) {
        List boxesIn = this.baseShape.m_83299_();
        VoxelShape rotated = Shapes.m_83040_();
        Matrix4f mat = MatrixUtils.facing(k);
        for (AABB original : boxesIn) {
            Vec3 minOld = new Vec3(original.f_82288_, original.f_82289_, original.f_82290_);
            Vec3 maxOld = new Vec3(original.f_82291_, original.f_82292_, original.f_82293_);
            Vec3 firstNew = MatrixUtils.transform(mat, minOld);
            Vec3 secondNew = MatrixUtils.transform(mat, maxOld);
            VoxelShape rotatedBox = Shapes.m_83064_((AABB)new AABB(firstNew, secondNew));
            rotated = Shapes.m_83148_((VoxelShape)rotated, (VoxelShape)rotatedBox, (BooleanOp)BooleanOp.f_82695_);
        }
        return rotated.m_83296_();
    }

    @Override
    protected Direction getKey(BlockState state, BlockGetter world, BlockPos pos) {
        return this.getKey.apply(state, world, pos);
    }
}

