/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.shapes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@FunctionalInterface
public interface FromBlockFunction<T> {
    public T apply(BlockState var1, BlockGetter var2, BlockPos var3);

    public static <T extends Comparable<T>> FromBlockFunction<T> getProperty(Property<T> prop) {
        return (state, w, p) -> state.m_61143_(prop);
    }

    public static <T> FromBlockFunction<T> either(FromBlockFunction<Boolean> useSecond, FromBlockFunction<T> first, FromBlockFunction<T> second) {
        return FromBlockFunction.switchOn(useSecond, ImmutableMap.of((Object)false, first, (Object)true, second));
    }

    public static <T> FromBlockFunction<T> eitherFlat(FromBlockFunction<Boolean> useSecond, T first, T second) {
        return FromBlockFunction.either(useSecond, FromBlockFunction.constant(first), FromBlockFunction.constant(second));
    }

    public static <T, T2 extends Comparable<T2>> FromBlockFunction<T> switchOn(FromBlockFunction<T2> prop, Map<T2, FromBlockFunction<T>> subFunctions) {
        return (state, world, pos) -> ((FromBlockFunction)subFunctions.get(prop.apply(state, world, pos))).apply(state, world, pos);
    }

    public static <T> FromBlockFunction<T> constant(T value) {
        return (s, w, p) -> value;
    }
}

