/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.shapes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.BiFunction;
import malte0811.controlengineering.blocks.shapes.DirectionalShapeProvider;
import malte0811.controlengineering.blocks.shapes.FromBlockFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HorizontalWithExtraShape<T>
implements BiFunction<T, Direction, VoxelShape>,
FromBlockFunction<VoxelShape> {
    private final FromBlockFunction<T> getKey;
    private final FromBlockFunction<Direction> getFacing;
    private final Map<T, DirectionalShapeProvider> shape;

    public HorizontalWithExtraShape(FromBlockFunction<T> getKey, FromBlockFunction<Direction> getFacing, Map<T, VoxelShape> shapes) {
        this.getKey = getKey;
        this.getFacing = getFacing;
        this.shape = (Map)shapes.entrySet().stream().map(p -> Pair.of(p.getKey(), (Object)new DirectionalShapeProvider(getFacing, (VoxelShape)p.getValue()))).collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
    }

    @Override
    public VoxelShape apply(T key, Direction direction) {
        return this.shape.get(key).apply(direction);
    }

    @Override
    public VoxelShape apply(BlockState state, BlockGetter world, BlockPos pos) {
        return this.apply(this.getKey.apply(state, world, pos), this.getFacing.apply(state, world, pos));
    }
}

