/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.shapes;

import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blocks.shapes.SelectionShapes;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ListShapes
extends SelectionShapes {
    private final VoxelShape mainShape;
    private final Matrix4f outerToInner;
    private final List<? extends SelectionShapes> shapes;
    private final Function<UseOnContext, InteractionResult> onClick;
    private boolean allowTargetThrough = false;

    public ListShapes(VoxelShape mainShape, Matrix4f outerToInner, List<? extends SelectionShapes> shapes, Function<UseOnContext, InteractionResult> onClick) {
        this.mainShape = mainShape;
        this.outerToInner = outerToInner;
        this.shapes = shapes;
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public VoxelShape mainShape() {
        return this.mainShape;
    }

    @Override
    @Nonnull
    public Matrix4f outerToInnerPosition() {
        return this.outerToInner;
    }

    @Override
    @Nonnull
    public List<? extends SelectionShapes> innerShapes() {
        return this.shapes;
    }

    @Override
    public InteractionResult onUse(UseOnContext ctx, InteractionResult defaultType, Vec3 relativeHit) {
        if (defaultType == InteractionResult.PASS) {
            return this.onClick.apply(ctx);
        }
        return defaultType;
    }

    public SelectionShapes setAllowTargetThrough(boolean b) {
        this.allowTargetThrough = b;
        return this;
    }

    @Override
    public boolean allowTargetThroughOuter() {
        return this.allowTargetThrough;
    }
}

