/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.blocks.shapes;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.util.math.MatrixUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SelectionShapes {
    private Supplier<Component> getText = () -> null;

    @Nullable
    public abstract VoxelShape mainShape();

    @Nonnull
    public abstract Matrix4f outerToInnerPosition();

    @Nonnull
    public abstract List<? extends SelectionShapes> innerShapes();

    @Nullable
    public final Component getOverlayText() {
        return this.getText.get();
    }

    public SelectionShapes setTextGetter(Supplier<Component> getText) {
        this.getText = getText;
        return this;
    }

    public abstract InteractionResult onUse(UseOnContext var1, InteractionResult var2, Vec3 var3);

    public void plotBox(BiConsumer<Vec3, Vec3> drawLine) {
        VoxelShape main = this.mainShape();
        if (main != null) {
            main.m_83224_((x1, y1, z1, x2, y2, z2) -> drawLine.accept(new Vec3(x1, y1, z1), new Vec3(x2, y2, z2)));
        }
    }

    public final InteractionResult onUse(UseOnContext useCtx, ClipContext ray) {
        Pair<List<SelectionShapes>, Vec3> targeted = this.getTargeted(ray);
        List stack = (List)targeted.getFirst();
        InteractionResult ret = InteractionResult.PASS;
        for (int i = 0; i < stack.size(); ++i) {
            ret = ((SelectionShapes)stack.get(stack.size() - i - 1)).onUse(useCtx, ret, (Vec3)targeted.getSecond());
        }
        return ret;
    }

    public final Pair<List<SelectionShapes>, Vec3> getTargeted(ClipContext ray) {
        BlockHitResult result;
        double maxDistanceForInner = Double.POSITIVE_INFINITY;
        VoxelShape mainShape = this.mainShape();
        if (mainShape != null && (result = mainShape.m_83220_(ray.m_45702_(), ray.m_45693_(), BlockPos.f_121853_)) != null) {
            maxDistanceForInner = result.m_82450_().m_82557_(ray.m_45702_());
        }
        ArrayList<SelectionShapes> stack = new ArrayList<SelectionShapes>();
        Vec3 innermostHit = this.fillTargetedStack(ray, maxDistanceForInner, stack);
        return Pair.of(stack, (Object)innermostHit);
    }

    private Vec3 fillTargetedStack(ClipContext ray, double limitDistanceSq, List<SelectionShapes> out) {
        Vec3 innerHit;
        out.add(this);
        List<? extends SelectionShapes> innerShapes = this.innerShapes();
        if (innerShapes.isEmpty()) {
            return null;
        }
        ClipContext innerRay = MatrixUtils.transformRay(this.outerToInnerPosition(), ray.m_45702_(), ray.m_45693_());
        SelectionShapes closest = null;
        double minDistanceSq = this.allowTargetThroughOuter() ? Double.POSITIVE_INFINITY : limitDistanceSq + 0.001;
        Vec3 closestHit = null;
        for (SelectionShapes selectionShapes : innerShapes) {
            double distanceSq;
            BlockHitResult result;
            VoxelShape innerShape = selectionShapes.mainShape();
            if (innerShape == null || (result = innerShape.m_83220_(innerRay.m_45702_(), innerRay.m_45693_(), BlockPos.f_121853_)) == null || !((distanceSq = result.m_82450_().m_82557_(innerRay.m_45702_())) < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            closest = selectionShapes;
            closestHit = result.m_82450_();
        }
        if (closest != null && (innerHit = closest.fillTargetedStack(innerRay, minDistanceSq, out)) != null) {
            return innerHit;
        }
        return closestHit;
    }

    public boolean shouldRenderNonTop() {
        return false;
    }

    public boolean allowTargetThroughOuter() {
        return false;
    }
}

