/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.bus;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import malte0811.controlengineering.bus.BusState;

public class BusEmitterCombiner<T> {
    private final Function<T, BusState> getEmittedState;
    private final Consumer<T> updateTotalState;
    private final Map<T, BusState> outputByBlock = new HashMap<T, BusState>();
    @Nullable
    private BusState totalState = null;
    @Nullable
    private BusState totalEmittedState = null;

    public BusEmitterCombiner(Function<T, BusState> getEmittedState, Consumer<T> updateTotalState) {
        this.getEmittedState = getEmittedState;
        this.updateTotalState = updateTotalState;
    }

    public void addEmitter(T emitter) {
        this.outputByBlock.put(emitter, this.getEmittedState.apply(emitter));
    }

    public void removeEmitterIfPresent(T emitter) {
        this.outputByBlock.remove(emitter);
    }

    public void updateState(BusState initialState) {
        BusState oldState = this.totalState;
        this.totalEmittedState = BusState.EMPTY;
        for (T key : this.outputByBlock.keySet()) {
            BusState emittedState = this.getEmittedState.apply(key);
            this.outputByBlock.put(key, emittedState);
            this.totalEmittedState = Objects.requireNonNull(this.totalEmittedState).merge(emittedState);
        }
        this.totalState = this.totalEmittedState.merge(initialState);
        if (oldState == null || !oldState.equals(this.totalState)) {
            for (T entry : this.outputByBlock.keySet()) {
                this.updateTotalState.accept(entry);
            }
        }
    }

    public BusState getTotalState() {
        return Objects.requireNonNullElse(this.totalState, BusState.EMPTY);
    }

    public BusState getTotalEmittedState() {
        return Objects.requireNonNullElse(this.totalEmittedState, BusState.EMPTY);
    }

    public BusState getStateWithout(T excluded) {
        BusState merged = BusState.EMPTY;
        for (Map.Entry<T, BusState> entry : this.outputByBlock.entrySet()) {
            if (excluded.equals(entry.getKey())) continue;
            merged = merged.merge(entry.getValue());
        }
        return merged;
    }

    public Iterable<T> getEmitters() {
        return this.outputByBlock.keySet();
    }

    public void clear() {
        this.outputByBlock.clear();
        this.totalEmittedState = null;
        this.totalState = null;
    }
}

