/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.bus;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Arrays;

public class BusLine {
    public static final int LINE_SIZE = 16;
    public static final int MAX_VALID_VALUE = 255;
    public static final int MIN_VALID_VALUE = 0;
    public static final int RS_SCALE_FACTOR = 17;
    public static final BusLine EMPTY = new BusLine();
    private final int[] values;

    public BusLine() {
        this(new int[16]);
    }

    private BusLine(Int2IntFunction rsValues) {
        int[] values = new int[16];
        for (int i = 0; i < 16; ++i) {
            values[i] = rsValues.applyAsInt(i) * 17;
        }
        this.values = values;
    }

    public BusLine(int[] values) {
        Preconditions.checkArgument((values.length == 16 ? 1 : 0) != 0);
        for (int val : values) {
            Preconditions.checkArgument((val >= 0 && val <= 255 ? 1 : 0) != 0);
        }
        this.values = values;
    }

    public static BusLine fromRSState(byte[] in) {
        Preconditions.checkArgument((in.length == 16 ? 1 : 0) != 0);
        return new BusLine(i -> in[i]);
    }

    public int getValue(int color) {
        return this.values[color];
    }

    public byte getRSValue(int color) {
        return (byte)(this.getValue(color) / 17);
    }

    public BusLine with(int color, int value) {
        Preconditions.checkArgument((value >= 0 && value <= 255 ? 1 : 0) != 0);
        int[] newValues = Arrays.copyOf(this.values, 16);
        newValues[color] = value;
        return new BusLine(newValues);
    }

    public BusLine merge(BusLine other) {
        int[] newValues = new int[16];
        for (int color = 0; color < 16; ++color) {
            newValues[color] = Math.max(this.getValue(color), other.getValue(color));
        }
        return new BusLine(newValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusLine busLine = (BusLine)o;
        return Arrays.equals(this.values, busLine.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

