/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.bus;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import malte0811.controlengineering.bus.BusLine;
import malte0811.controlengineering.bus.BusSignalRef;

public class BusState {
    public static final BusState EMPTY = new BusState();
    private final List<BusLine> lines;

    private BusState() {
        this.lines = new ArrayList<BusLine>(4);
        for (int i = 0; i < 4; ++i) {
            this.lines.add(new BusLine());
        }
    }

    private BusState(List<BusLine> lines) {
        this.lines = lines;
    }

    public BusLine getLine(int index) {
        if (index < this.lines.size()) {
            return this.lines.get(index);
        }
        return BusLine.EMPTY;
    }

    public BusState withLine(int index, BusLine line) {
        ArrayList<BusLine> newLines = new ArrayList<BusLine>(this.lines);
        newLines.set(index, line);
        return new BusState(newLines);
    }

    public BusState with(int index, int color, int value) {
        return this.with(new BusSignalRef(index, color), value);
    }

    public BusState with(BusSignalRef signal, int value) {
        BusLine newLine = this.getLine(signal.line()).with(signal.color(), value);
        return this.withLine(signal.line(), newLine);
    }

    public int getWidth() {
        return this.lines.size();
    }

    public BusState merge(BusState other) {
        if (other.getWidth() > this.getWidth()) {
            return other.merge(this);
        }
        ArrayList<BusLine> newLines = new ArrayList<BusLine>(this.lines);
        for (int line = 0; line < other.getWidth(); ++line) {
            newLines.set(line, this.getLine(line).merge(other.getLine(line)));
        }
        return new BusState(newLines);
    }

    public int getSignal(BusSignalRef signal) {
        if (signal.line() < this.lines.size()) {
            BusLine line = this.getLine(signal.line());
            return line.getValue(signal.color());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusState busState = (BusState)o;
        return this.lines.equals(busState.lines);
    }

    public int hashCode() {
        return Objects.hash(this.lines);
    }
}

