/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.bus;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import malte0811.controlengineering.bus.BusEmitterCombiner;
import malte0811.controlengineering.bus.BusState;
import malte0811.controlengineering.bus.IBusConnector;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class LocalBusHandler
extends LocalNetworkHandler
implements IWorldTickable {
    public static final ResourceLocation NAME = new ResourceLocation("controlengineering", "bus");
    private boolean updateNextTick = true;
    private final List<ConnectionPoint> loading = new ArrayList<ConnectionPoint>();
    private final BusEmitterCombiner<Pair<ConnectionPoint, IBusConnector>> stateHandler = new BusEmitterCombiner<Pair>(pair -> ((IBusConnector)pair.getSecond()).getEmittedState((ConnectionPoint)pair.getFirst()), pair -> ((IBusConnector)pair.getSecond()).onBusUpdated((ConnectionPoint)pair.getFirst()));

    public LocalBusHandler(LocalWireNetwork local, GlobalWireNetwork global) {
        super(local, global);
        this.loading.addAll(local.getConnectionPoints());
    }

    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        if (!(other instanceof LocalBusHandler)) {
            return new LocalBusHandler(this.localNet, this.globalNet);
        }
        LocalBusHandler otherBus = (LocalBusHandler)other;
        for (Pair<ConnectionPoint, IBusConnector> pair : otherBus.stateHandler.getEmitters()) {
            this.stateHandler.addEmitter(pair);
        }
        this.requestUpdate();
        return this;
    }

    public void setLocalNet(LocalWireNetwork net) {
        super.setLocalNet(net);
        this.stateHandler.clear();
        this.loading.addAll(this.localNet.getConnectionPoints());
        this.requestUpdate();
    }

    public void onConnectorLoaded(ConnectionPoint p, IImmersiveConnectable iic) {
        this.loading.add(p);
        this.requestUpdate();
    }

    private void loadConnectionPoint(ConnectionPoint cp) {
        IBusConnector busIIC;
        IImmersiveConnectable iic = this.localNet.getConnector(cp);
        if (iic instanceof IBusConnector && (busIIC = (IBusConnector)iic).isBusPoint(cp)) {
            this.stateHandler.addEmitter((Pair<ConnectionPoint, IBusConnector>)Pair.of((Object)cp, (Object)busIIC));
        }
    }

    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
        this.onConnectorRemoved(p, iic);
    }

    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
        if (iic instanceof IBusConnector) {
            IBusConnector busConnector = (IBusConnector)iic;
            for (ConnectionPoint cp : busConnector.getConnectionPoints()) {
                if (!busConnector.isBusPoint(cp)) continue;
                this.stateHandler.removeEmitterIfPresent((Pair<ConnectionPoint, IBusConnector>)Pair.of((Object)cp, (Object)busConnector));
            }
            this.requestUpdate();
        }
    }

    public void onConnectionAdded(Connection c) {
    }

    public void onConnectionRemoved(Connection c) {
    }

    public BusState getState() {
        return this.stateHandler.getTotalState();
    }

    public BusState getStateWithout(ConnectionPoint excluded, IBusConnector connector) {
        return this.stateHandler.getStateWithout((Pair<ConnectionPoint, IBusConnector>)Pair.of((Object)excluded, (Object)connector));
    }

    public void requestUpdate() {
        this.updateNextTick = true;
    }

    public void update(Level w) {
        if (!this.loading.isEmpty()) {
            for (ConnectionPoint point : this.loading) {
                this.loadConnectionPoint(point);
            }
        }
        if (this.updateNextTick) {
            this.stateHandler.updateState(BusState.EMPTY);
            this.updateNextTick = false;
        }
    }
}

