/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.manual;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.Tree;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import malte0811.controlengineering.client.manual.LeafcellElement;
import malte0811.controlengineering.client.manual.LeafcellWithStatesElement;
import malte0811.controlengineering.client.manual.PanelComponentElement;
import malte0811.controlengineering.controlpanels.PanelComponentInstance;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.PanelComponents;
import malte0811.controlengineering.controlpanels.PlacedComponent;
import malte0811.controlengineering.controlpanels.cnc.CNCInstructionGenerator;
import malte0811.controlengineering.util.math.Vec2d;
import malte0811.controlengineering.util.mycodec.MyCodec;
import malte0811.controlengineering.util.mycodec.MyCodecs;
import malte0811.controlengineering.util.mycodec.record.CodecField;
import malte0811.controlengineering.util.mycodec.record.RecordCodecBase;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class CEManual {
    public static final String NAME_KEY = CEManual.makeKey("name");
    public static final String OPTIONS_KEY = CEManual.makeKey("options");
    public static final String EXAMPLE_KEY = CEManual.makeKey("example");
    public static final Map<MyCodec<?>, String> CODEC_NAMES = ImmutableMap.builder().put(MyCodecs.INTEGER, (Object)CEManual.makeKey("integer")).put(MyCodecs.HEX_COLOR, (Object)CEManual.makeKey("color")).put(MyCodecs.STRING, (Object)CEManual.makeKey("text")).build();

    public static void initManual() {
        ManualInstance ieManual = ManualHelper.getManual();
        ieManual.registerSpecialElement(new ResourceLocation("controlengineering", "panel_component"), PanelComponentElement::new);
        ieManual.registerSpecialElement(new ResourceLocation("controlengineering", "leafcell"), json -> LeafcellElement.from(json, ieManual));
        ieManual.registerSpecialElement(new ResourceLocation("controlengineering", "leafcell_truth"), json -> LeafcellWithStatesElement.from(ieManual, json));
        CEManual.addComponentFormatEntry(ieManual);
    }

    private static void addComponentFormatEntry(ManualInstance ieManual) {
        Tree.InnerNode ceCategory = ieManual.getRoot().getOrCreateSubnode((Comparable)new ResourceLocation("controlengineering", "main"), 100);
        Tree.InnerNode panelCategory = ceCategory.getOrCreateSubnode((Comparable)new ResourceLocation("controlengineering", "panels"));
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.readFromFile(new ResourceLocation("controlengineering", "panels/panel_format"));
        builder.appendText(CEManual::makeComponentFormats);
        ieManual.addEntry(panelCategory, builder.create(), 1000);
    }

    private static Pair<String, List<ManualEntry.SpecialElementData>> makeComponentFormats() {
        StringBuilder entry = new StringBuilder();
        for (PanelComponentType<?, ?> component : PanelComponents.REGISTRY.getValues()) {
            entry.append("<np>");
            CEManual.appendBoldTranslated(entry, component.getTranslationKey()).append("\n");
            CEManual.appendBoldTranslated(entry, NAME_KEY).append(": ").append(PanelComponents.getCreationKey(component)).append('\n');
            CEManual.appendBoldTranslated(entry, OPTIONS_KEY).append(":\n");
            CEManual.describeCodec(component.getConfigCodec(), entry, "");
            entry.append('\n');
            PlacedComponent exampleComponent = new PlacedComponent((PanelComponentInstance)component.newInstance(), new Vec2d(3.0, 4.0));
            CEManual.appendBoldTranslated(entry, EXAMPLE_KEY).append(": ");
            CNCInstructionGenerator.toInstructions(entry, exampleComponent).append('\n');
        }
        return Pair.of((Object)entry.toString(), List.of());
    }

    private static void describeCodec(RecordCodecBase<?> codec, StringBuilder entry, String prefix) {
        for (CodecField<?, ?> field : codec.getFields()) {
            entry.append(prefix);
            MyCodec<?> myCodec = field.codec();
            if (myCodec instanceof RecordCodecBase) {
                RecordCodecBase innerRecordCodec = (RecordCodecBase)myCodec;
                entry.append(field.name()).append(":\n");
                CEManual.describeCodec(innerRecordCodec, entry, prefix + "\u00a0");
                continue;
            }
            String codecName = CODEC_NAMES.get(field.codec());
            Preconditions.checkNotNull((Object)codecName, (Object)("Unknown codec " + field.codec() + " for field " + field.name()));
            entry.append(field.name()).append(": ").append(I18n.m_118938_((String)codecName, (Object[])new Object[0])).append('\n');
        }
    }

    private static StringBuilder appendBoldTranslated(StringBuilder in, String key) {
        return in.append(ChatFormatting.BOLD).append(I18n.m_118938_((String)key, (Object[])new Object[0])).append(ChatFormatting.RESET);
    }

    private static String makeKey(String name) {
        return "controlengineering.manual.component." + name;
    }
}

