/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import malte0811.controlengineering.items.IEItemRefs;
import malte0811.controlengineering.logic.cells.CellCost;
import malte0811.controlengineering.logic.schematic.client.ClientSymbols;
import malte0811.controlengineering.logic.schematic.symbol.CellSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbols;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LeafcellElement<State>
extends SpecialManualElement {
    public static final String COST_KEY = "controlengineering.gui.leafcell.cost";
    private static final int SCALE = 5;
    private static final int ITEM_SIZE = 18;
    private final SchematicSymbol<State> type;
    private final ManualInstance manual;

    public LeafcellElement(SchematicSymbol<State> type, ManualInstance manual) {
        this.type = type;
        this.manual = manual;
    }

    public static LeafcellElement<?> from(ResourceLocation name, ManualInstance manual) {
        return new LeafcellElement(SchematicSymbols.REGISTRY.get(name), manual);
    }

    public static LeafcellElement<?> from(JsonObject obj, ManualInstance manual) {
        return LeafcellElement.from(new ResourceLocation(obj.get("cell").getAsString()), manual);
    }

    public int getPixelsTaken() {
        int n = this.type.getDefaultYSize((Level)Minecraft.m_91087_().f_91073_) * 5;
        Objects.requireNonNull(this.manual.fontRenderer());
        return Math.max(n, 9 + 36) + 4;
    }

    public void onOpened(ManualScreen gui, int x, int y, List<Button> buttons) {
    }

    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        ManualInstance manual = gui.getManual();
        transform.m_85836_();
        double offsetX = ((double)manual.pageWidth * 0.6666666666666666 - (double)(this.type.getDefaultXSize((Level)Minecraft.m_91087_().f_91073_) * 5)) / 2.0;
        transform.m_85837_((double)x + offsetX, (double)y, 0.0);
        transform.m_85841_(5.0f, 5.0f, 5.0f);
        ClientSymbols.render(this.type, transform, 0, 0, this.type.getInitialState());
        transform.m_85849_();
        SchematicSymbol<State> schematicSymbol = this.type;
        if (schematicSymbol instanceof CellSymbol) {
            CellSymbol cell = (CellSymbol)schematicSymbol;
            CellCost cost = cell.getCellType().getCost();
            Font font = manual.fontRenderer();
            Objects.requireNonNull(font);
            int costStartY = y + 9;
            int xRight = x + manual.pageWidth;
            String costLabel = I18n.m_118938_((String)COST_KEY, (Object[])new Object[0]);
            font.m_92883_(transform, costLabel, (float)(xRight - font.m_92895_(costLabel) - 2), (float)y, 0);
            this.renderCost(transform, font, xRight, costStartY, cost.numTubes(), IEItemRefs.TUBE);
            this.renderCost(transform, font, xRight, costStartY + 18, cost.wireLength(), IEItemRefs.WIRE);
        }
    }

    private void renderCost(PoseStack transform, Font font, int xRight, int y, double amount, ItemLike item) {
        String text = amount + " x ";
        int textWidth = font.m_92895_(text);
        int xLeft = xRight - 18 - textWidth;
        ManualUtils.renderItemStack((PoseStack)transform, (ItemStack)item.m_5456_().m_7968_(), (int)(xRight - 18), (int)y, (boolean)false);
        float f = xLeft;
        float f2 = y;
        Objects.requireNonNull(font);
        font.m_92883_(transform, text, f, f2 + (float)(18 - 9) / 2.0f, 0);
    }

    public void mouseDragged(int x, int y, double clickX, double clickY, double mx, double my, double lastX, double lastY, int mouseButton) {
    }

    public boolean listForSearch(String searchTag) {
        return false;
    }

    public void recalculateCraftingRecipes() {
    }
}

