/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.manual;

import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import malte0811.controlengineering.client.manual.LeafcellElement;
import malte0811.controlengineering.logic.cells.CircuitSignals;
import malte0811.controlengineering.logic.cells.LeafcellType;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbol;
import malte0811.controlengineering.logic.schematic.symbol.SchematicSymbols;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class LeafcellWithStatesElement
extends SpecialManualElement {
    private final ManualInstance manual;
    private final SchematicSymbol<?> symbol;
    private final LeafcellElement<?> display;
    private final ManualElementTable truthTable;

    private LeafcellWithStatesElement(ManualInstance manual, ResourceLocation cellName) {
        this.manual = manual;
        this.symbol = SchematicSymbols.REGISTRY.get(cellName);
        this.display = new LeafcellElement(this.symbol, manual);
        LeafcellType<?, ?> cell = Objects.requireNonNull(LeafcellType.REGISTRY.get(cellName));
        ArrayList table = new ArrayList();
        List inputNames = cell.getInputPins().keySet().stream().sorted().toList();
        List outputNames = cell.getOutputPins().keySet().stream().sorted().toList();
        ArrayList<TextComponent> namesRow = new ArrayList<TextComponent>();
        for (List pinList : List.of(inputNames, outputNames)) {
            for (String pin : pinList) {
                namesRow.add(new TextComponent(pin.toUpperCase(Locale.ROOT)));
            }
        }
        table.add(namesRow);
        Object2IntOpenHashMap inputs = new Object2IntOpenHashMap();
        for (int packedInputs = 0; packedInputs < 1 << inputNames.size(); ++packedInputs) {
            ArrayList<TextComponent> line = new ArrayList<TextComponent>();
            for (int i = 0; i < inputNames.size(); ++i) {
                int value = packedInputs >> i & 1;
                inputs.put((Object)((String)inputNames.get(i)), value * 255);
                line.add(new TextComponent(Integer.toString(value)));
            }
            CircuitSignals outputs = cell.getOutputSignals(new CircuitSignals((Object2IntMap<String>)inputs), null, null);
            for (String output : outputNames) {
                line.add(new TextComponent(outputs.bool(output) ? "1" : "0"));
            }
            table.add(line);
        }
        this.truthTable = new ManualElementTable(manual, (Component[][])table.stream().map(l -> (Component[])l.toArray(Component[]::new)).toArray(x$0 -> new Component[x$0][]), false);
    }

    public static LeafcellWithStatesElement from(ManualInstance manual, JsonObject obj) {
        return new LeafcellWithStatesElement(manual, new ResourceLocation(obj.get("cell").getAsString()));
    }

    public int getPixelsTaken() {
        return this.getPixelsBeforeTable() + this.truthTable.getPixelsTaken();
    }

    private int getPixelsBeforeTable() {
        int n = this.display.getPixelsTaken();
        Objects.requireNonNull(this.manual.fontRenderer());
        return n + 9;
    }

    public void onOpened(ManualScreen gui, int x, int y, List<Button> buttons) {
    }

    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        this.display.render(transform, gui, x, y, mouseX, mouseY);
        Component name = this.symbol.getDefaultName();
        int nameWidth = this.manual.fontRenderer().m_92852_((FormattedText)name);
        this.manual.fontRenderer().m_92889_(transform, name, (float)x + (float)(this.manual.pageWidth - nameWidth) / 2.0f, (float)(y + this.display.getPixelsTaken() - 4), 0);
        this.truthTable.render(transform, gui, x, y + this.getPixelsBeforeTable(), mouseX, mouseY);
    }

    public void mouseDragged(int x, int y, double clickX, double clickY, double mx, double my, double lastX, double lastY, int mouseButton) {
    }

    public boolean listForSearch(String searchTag) {
        return false;
    }

    public void recalculateCraftingRecipes() {
    }
}

