/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.manual;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import malte0811.controlengineering.controlpanels.PanelComponentType;
import malte0811.controlengineering.controlpanels.PanelComponents;
import malte0811.controlengineering.gui.panel.ComponentSelector;
import malte0811.controlengineering.util.ScreenUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PanelComponentElement
extends SpecialManualElement {
    private static final int ITEM_SIZE = 18;
    public static final String INGREDIENTS_KEY = "controlengineering.gui.component_ingredients";
    private static final Component INGREDIENTS_LABEL = new TranslatableComponent("controlengineering.gui.component_ingredients");
    private final PanelComponentType<?, ?> type;
    private List<List<ItemStack>> ingredients = List.of();

    public PanelComponentElement(PanelComponentType<?, ?> type) {
        this.type = type;
    }

    public PanelComponentElement(ResourceLocation name) {
        this(PanelComponents.REGISTRY.get(name));
    }

    public PanelComponentElement(JsonObject obj) {
        this(new ResourceLocation(obj.get("component").getAsString()));
    }

    public int getPixelsTaken() {
        int n = this.getComponentDemoHeight();
        Objects.requireNonNull(this.getFont());
        return n + 9;
    }

    private int getComponentDemoHeight() {
        return Math.max(this.ingredients.size(), 3) * 18;
    }

    public void onOpened(ManualScreen gui, int x, int y, List<Button> buttons) {
    }

    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        ManualInstance manual = gui.getManual();
        transform.m_85836_();
        transform.m_85837_((double)x, (double)y, 0.0);
        Font font = this.getFont();
        int labelWidth = font.m_92852_((FormattedText)INGREDIENTS_LABEL);
        font.m_92889_(transform, INGREDIENTS_LABEL, (float)(manual.pageWidth - labelWidth), 0.0f, 0);
        Objects.requireNonNull(font);
        transform.m_85837_(0.0, 9.0, 0.0);
        List<ItemStack> shownIngredients = this.getShownIngredients();
        int n = manual.pageWidth;
        Objects.requireNonNull(font);
        ItemStack tooltipStack = this.renderIngredients(transform, shownIngredients, n, mouseX, mouseY - 9);
        ComponentSelector.renderComponentInGui(transform, this.type, manual.pageWidth - 18, this.getComponentDemoHeight());
        transform.m_85849_();
        if (!tooltipStack.m_41619_()) {
            gui.m_6057_(transform, tooltipStack, mouseX, mouseY);
        }
    }

    private ItemStack renderIngredients(PoseStack transform, List<ItemStack> shownIngredients, int width, int mouseX, int mouseY) {
        ItemStack highlighted = ItemStack.f_41583_;
        for (int i = 0; i < shownIngredients.size(); ++i) {
            int x = width - 18;
            int y = i * 18;
            ItemStack item = shownIngredients.get(i);
            ManualUtils.renderItemStack((PoseStack)transform, (ItemStack)item, (int)x, (int)y, (boolean)false);
            if (!highlighted.m_41619_() || !ScreenUtils.isInRect(x, y, 18, 18, mouseX, mouseY)) continue;
            highlighted = item;
        }
        return highlighted;
    }

    public void mouseDragged(int x, int y, double clickX, double clickY, double mx, double my, double lastX, double lastY, int mouseButton) {
    }

    public boolean listForSearch(String searchTag) {
        return false;
    }

    public void recalculateCraftingRecipes() {
        this.ingredients = this.type.getCost((Level)Minecraft.m_91087_().f_91073_).stream().map(IngredientWithSize::getMatchingStackList).toList();
    }

    private List<ItemStack> getShownIngredients() {
        long second = System.currentTimeMillis() / 1000L;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (List<ItemStack> candidates : this.ingredients) {
            result.add(candidates.get((int)(second % (long)candidates.size())));
        }
        return result;
    }

    private Font getFont() {
        return ManualHelper.getManual().fontRenderer();
    }
}

