/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.model;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.client.model.CEBakedModel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public record CacheableCompositeModel(List<ICacheKeyProvider<?>> cacheableSubModels, List<BakedQuad> simpleQuads, ModelState modelTransform) implements CEBakedModel.Cacheable<List<?>>
{
    private static final ModelProperty<List<IModelData>> SUB_MODEL_DATA = new ModelProperty();

    @Override
    public List<BakedQuad> getQuads(List<?> key) {
        if (this.cacheableSubModels.size() != key.size()) {
            return List.of();
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(this.simpleQuads);
        for (int i = 0; i < this.cacheableSubModels.size(); ++i) {
            ICacheKeyProvider<?> cacheable = this.cacheableSubModels.get(i);
            result.addAll(this.getQuads(cacheable, key.get(i)));
        }
        return result;
    }

    private <K> List<BakedQuad> getQuads(ICacheKeyProvider<K> cacheable, Object key) {
        return cacheable.getQuads(key);
    }

    @Override
    public List<?> getKey(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null) {
            return List.of();
        }
        List subProperties = (List)extraData.getData(SUB_MODEL_DATA);
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.cacheableSubModels.size(); ++i) {
            ICacheKeyProvider<?> cacheable = this.cacheableSubModels.get(i);
            result.add(cacheable.getKey(state, null, rand, (IModelData)(subProperties != null ? (IModelData)subProperties.get(i) : EmptyModelData.INSTANCE)));
        }
        return result;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData modelData) {
        ArrayList<IModelData> subData = new ArrayList<IModelData>(this.cacheableSubModels.size());
        for (ICacheKeyProvider<?> cacheable : this.cacheableSubModels) {
            subData.add(cacheable.getModelData(level, pos, state, modelData));
        }
        return new SinglePropertyModelData(subData, SUB_MODEL_DATA);
    }

    @Override
    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        if (!this.simpleQuads.isEmpty()) {
            return this.simpleQuads.get(0).m_173410_();
        }
        return this.cacheableSubModels.get(0).getParticleIcon(data);
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType type, PoseStack transform) {
        this.modelTransform.getPartTransformation((Object)type).push(transform);
        return this;
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public static final String SUBMOCELS = "submodels";

        @Nonnull
        public Geometry read(@Nonnull JsonDeserializationContext deserializationContext, @Nonnull JsonObject modelContents) {
            ArrayList<BlockModel> submodels = new ArrayList<BlockModel>();
            for (JsonElement submodel : modelContents.getAsJsonArray(SUBMOCELS)) {
                submodels.add((BlockModel)ModelLoaderRegistry.ExpandedBlockModelDeserializer.INSTANCE.fromJson(submodel, BlockModel.class));
            }
            return new Geometry(submodels);
        }

        public void m_6213_(@Nonnull ResourceManager modelpResourceManager) {
        }
    }

    private record Geometry(List<BlockModel> subModels) implements IModelGeometry<Geometry>
    {
        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            ArrayList bakedSubModels = new ArrayList();
            for (BlockModel model : this.subModels) {
                BakedModel baked = model.m_111449_(bakery, model, spriteGetter, modelTransform, modelLocation, true);
                if (baked instanceof SimpleBakedModel) {
                    SimpleBakedModel simple = (SimpleBakedModel)baked;
                    quads.addAll(simple.getQuads(null, null, ApiUtils.RANDOM, (IModelData)EmptyModelData.INSTANCE));
                    for (Direction side : DirectionUtils.VALUES) {
                        quads.addAll(simple.getQuads(null, side, ApiUtils.RANDOM, (IModelData)EmptyModelData.INSTANCE));
                    }
                    continue;
                }
                if (baked instanceof ICacheKeyProvider) {
                    ICacheKeyProvider cacheable = (ICacheKeyProvider)baked;
                    bakedSubModels.add(cacheable);
                    continue;
                }
                throw new RuntimeException("Unexpected submodel " + baked);
            }
            return new CacheableCompositeModel(bakedSubModels, quads, owner.getCombinedTransform());
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet<Material> set = new HashSet<Material>();
            for (BlockModel bm : this.subModels) {
                set.addAll(bm.m_5500_(modelGetter, missingTextureErrors));
            }
            return set;
        }
    }
}

