/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.model.logic;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.client.model.CEBakedModel;
import malte0811.controlengineering.client.render.target.QuadBuilder;
import malte0811.controlengineering.client.render.utils.BakedQuadVertexBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class DynamicLogicModel
implements CEBakedModel.Cacheable<Pair<ModelData, RenderType>> {
    private static final Random RANDOM = new Random(1234L);
    private static final Vec2[] TUBE_OFFSETS;
    private static final float[] BOARD_HEIGHTS;
    public static final ModelProperty<ModelData> DATA;
    private final UnbakedModel board;
    private final UnbakedModel tube;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final TextureAtlasSprite particles;
    private final BakedQuad clockQuad;
    private final List<FixedTubeModel> knownModels = new ArrayList<FixedTubeModel>();

    public DynamicLogicModel(UnbakedModel board, UnbakedModel tube, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform) {
        this.board = board;
        this.tube = tube;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.particles = ((BakedQuad)board.m_7611_(bakery, spriteGetter, modelTransform, new ResourceLocation("controlengineering", "temp")).getQuads(null, null, RANDOM, (IModelData)EmptyModelData.INSTANCE).get(0)).m_173410_();
        PoseStack transform = new PoseStack();
        modelTransform.m_6189_().blockCenterToCorner().push(transform);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        new QuadBuilder(new Vec3(1.0, 0.375, 0.625), new Vec3(1.0, 0.375, 0.375), new Vec3(1.0, 0.625, 0.375), new Vec3(1.0, 0.625, 0.625)).setSprite(this.particles).setUCoords(0.9375f, 0.9375f, 1.0f, 1.0f).setVCoords(0.0f, 0.0625f, 0.0625f, 0.0f).writeTo(new BakedQuadVertexBuilder(this.particles, transform, quads).dontInterpolateUV());
        this.clockQuad = (BakedQuad)quads.get(0);
    }

    @Override
    public List<BakedQuad> getQuads(Pair<ModelData, RenderType> dataPair) {
        List<BakedQuad> quads;
        ModelData data = (ModelData)dataPair.getFirst();
        while (this.knownModels.size() <= data.numTubes) {
            this.knownModels.add(null);
        }
        if (data.numTubes >= 0) {
            FixedTubeModel result = this.knownModels.get(data.numTubes);
            if (result == null) {
                result = new FixedTubeModel(data.numTubes);
                this.knownModels.set(data.numTubes, result);
            }
            quads = result.getQuads((RenderType)dataPair.getSecond());
        } else {
            quads = new ArrayList<BakedQuad>();
        }
        if (data.hasClock) {
            quads = new ArrayList<BakedQuad>(quads);
            quads.add(this.clockQuad);
        }
        return quads;
    }

    @Override
    @Nullable
    public Pair<ModelData, RenderType> getKey(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return Pair.of((Object)Objects.requireNonNullElseGet((ModelData)extraData.getData(DATA), () -> new ModelData(-1, false)), (Object)MinecraftForgeClient.getRenderType());
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.particles;
    }

    static {
        BOARD_HEIGHTS = new float[]{1.03125f, 1.34375f, 0.78125f, 1.65625f};
        DATA = new ModelProperty();
        int[] tubeAxisOffsets = new int[]{0, 3, 7, 10};
        TUBE_OFFSETS = (Vec2[])Arrays.stream(tubeAxisOffsets).boxed().flatMap(i -> Arrays.stream(tubeAxisOffsets).mapToObj(i2 -> new int[]{i, i2})).map(a -> new Vec2((float)a[0] / 16.0f, (float)a[1] / 16.0f)).toArray(Vec2[]::new);
        Collections.shuffle(Arrays.asList(TUBE_OFFSETS), RANDOM);
    }

    public record ModelData(int numTubes, boolean hasClock) {
    }

    private class FixedTubeModel {
        private final List<BakedQuad> solid;
        private final List<BakedQuad> translucent;

        public FixedTubeModel(int numTubes) {
            ArrayList<BakedQuad> solid = new ArrayList<BakedQuad>();
            ArrayList<BakedQuad> translucent = new ArrayList<BakedQuad>();
            int numAdded = 0;
            for (float y : BOARD_HEIGHTS) {
                solid.addAll(this.translated(DynamicLogicModel.this.board, new Vector3f(0.0f, y, 0.0f)));
                for (Vec2 xz : TUBE_OFFSETS) {
                    if (numAdded >= numTubes) break;
                    translucent.addAll(this.translated(DynamicLogicModel.this.tube, new Vector3f(-xz.f_82470_, y, -xz.f_82471_)));
                    ++numAdded;
                }
                if (numAdded >= numTubes) break;
            }
            this.solid = ImmutableList.copyOf(solid);
            this.translucent = ImmutableList.copyOf(translucent);
        }

        private List<BakedQuad> translated(UnbakedModel model, Vector3f offset) {
            SimpleModelState offsetTransform = new SimpleModelState(new Transformation(offset, null, null, null));
            ResourceLocation dummy = new ResourceLocation("controlengineering", "dynamic");
            BakedModel baked = model.m_7611_(DynamicLogicModel.this.bakery, DynamicLogicModel.this.spriteGetter, (ModelState)new CompositeModelState(DynamicLogicModel.this.modelTransform, (ModelState)offsetTransform), dummy);
            if (baked == null) {
                return ImmutableList.of();
            }
            return baked.getQuads(null, null, RANDOM, (IModelData)EmptyModelData.INSTANCE);
        }

        public List<BakedQuad> getQuads(RenderType currentType) {
            if (currentType == RenderType.m_110451_()) {
                return this.solid;
            }
            if (currentType == RenderType.m_110466_()) {
                return this.translucent;
            }
            return ImmutableList.of();
        }
    }
}

