/*
 * Decompiled with CFR 0.152.
 */
package malte0811.controlengineering.client.model.logic;

import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.controlengineering.blockentity.logic.LogicWorkbenchBlockEntity;
import malte0811.controlengineering.client.model.CEBakedModel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public record LogicWorkbenchModel(BakedModel workbench, BakedModel schematic, ModelState transforms) implements CEBakedModel
{
    private static final ModelProperty<Boolean> HAS_SCHEMATIC = new ModelProperty();

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList quads = this.workbench.getQuads(state, side, rand, extraData);
        Boolean hasSchematic = (Boolean)extraData.getData(HAS_SCHEMATIC);
        if (hasSchematic != Boolean.FALSE) {
            quads = new ArrayList(quads);
            quads.addAll(this.schematic.getQuads(state, side, rand, extraData));
        }
        return quads;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData modelData) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LogicWorkbenchBlockEntity) {
            LogicWorkbenchBlockEntity workbench = (LogicWorkbenchBlockEntity)blockEntity;
            return CombinedModelData.combine((IModelData[])new IModelData[]{modelData, new SinglePropertyModelData((Object)(workbench.getSchematic() != null ? 1 : 0), HAS_SCHEMATIC)});
        }
        return modelData;
    }

    @Override
    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.workbench.getParticleIcon(data);
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType transformType, PoseStack transform) {
        this.transforms.getPartTransformation((Object)transformType).push(transform);
        return this;
    }

    private record Geometry(BlockModel workbench, BlockModel schematic) implements IModelGeometry<Geometry>
    {
        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new LogicWorkbenchModel(this.workbench.m_111449_(bakery, this.workbench, spriteGetter, modelTransform, modelLocation, false), this.schematic.m_111449_(bakery, this.schematic, spriteGetter, modelTransform, modelLocation, false), owner.getCombinedTransform());
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet<Material> allTextures = new HashSet<Material>(this.workbench.m_5500_(modelGetter, missingTextureErrors));
            allTextures.addAll(this.schematic.m_5500_(modelGetter, missingTextureErrors));
            return allTextures;
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public static final String WORKBENCH = "workbench";
        public static final String SCHEMATIC = "schematic";

        @Nonnull
        public Geometry read(@Nonnull JsonDeserializationContext deserializationContext, @Nonnull JsonObject modelContents) {
            Gson modelGson = ModelLoaderRegistry.ExpandedBlockModelDeserializer.INSTANCE;
            BlockModel workbench = (BlockModel)modelGson.fromJson(modelContents.get(WORKBENCH), BlockModel.class);
            BlockModel schematic = (BlockModel)modelGson.fromJson(modelContents.get(SCHEMATIC), BlockModel.class);
            return new Geometry(workbench, schematic);
        }

        public void m_6213_(@Nonnull ResourceManager pResourceManager) {
        }
    }
}

